@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
 * @property values The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
 */
public data class InstanceAccessControlAttributesAttributeArgs(
    public val key: Output<String>,
    public val values: Output<List<InstanceAccessControlAttributesAttributeValueArgs>>,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeArgs =
        com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .values(
                values.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InstanceAccessControlAttributesAttributeArgs].
 */
@PulumiTagMarker
public class InstanceAccessControlAttributesAttributeArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var values: Output<List<InstanceAccessControlAttributesAttributeValueArgs>>? = null

    /**
     * @param value The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
     */
    @JvmName("xstrxhlfcxuamkiv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
     */
    @JvmName("qahbywtwdqssyfmj")
    public suspend
    fun values(`value`: Output<List<InstanceAccessControlAttributesAttributeValueArgs>>) {
        this.values = value
    }

    @JvmName("nqvpovuhtwyvxwqx")
    public suspend fun values(
        vararg
        values: Output<InstanceAccessControlAttributesAttributeValueArgs>,
    ) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
     */
    @JvmName("uofewwlpgyotmhda")
    public suspend
    fun values(values: List<Output<InstanceAccessControlAttributesAttributeValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
     */
    @JvmName("hhqakiqxdrpiclwd")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
     */
    @JvmName("auihfqrfhjwolquc")
    public suspend fun values(`value`: List<InstanceAccessControlAttributesAttributeValueArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
     */
    @JvmName("gdjceyjyfwceuuev")
    public suspend
    fun values(argument: List<suspend InstanceAccessControlAttributesAttributeValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceAccessControlAttributesAttributeValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
     */
    @JvmName("dajpchaghakeskfg")
    public suspend fun values(
        vararg
        argument: suspend InstanceAccessControlAttributesAttributeValueArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstanceAccessControlAttributesAttributeValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
     */
    @JvmName("pslbptfwktlvpwks")
    public suspend
    fun values(argument: suspend InstanceAccessControlAttributesAttributeValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceAccessControlAttributesAttributeValueArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
     */
    @JvmName("uqnglcubogqjjulq")
    public suspend fun values(vararg values: InstanceAccessControlAttributesAttributeValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): InstanceAccessControlAttributesAttributeArgs =
        InstanceAccessControlAttributesAttributeArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
