@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the customer managed IAM Policy to be attached.
 * @property path The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
 */
public data class
PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs(
    public val name: Output<String>,
    public val path: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs> {
    override fun toJava():
        com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs =
        com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs].
 */
@PulumiTagMarker
public class
PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var path: Output<String>? = null

    /**
     * @param value Name of the customer managed IAM Policy to be attached.
     */
    @JvmName("llhxxtcsrnfxhhhq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
     */
    @JvmName("kxafvyggcldjxyjb")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Name of the customer managed IAM Policy to be attached.
     */
    @JvmName("shalxohclhnckxgi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
     */
    @JvmName("qohgyyqmqycgegef")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build():
        PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs =
        PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            path = path,
        )
}
