@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the customer managed IAM Policy to be attached.
 * @property path The path to the IAM policy to be attached. The default is `/`. See [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names) for more information.
 */
public data class CustomerManagedPolicyAttachmentCustomerManagedPolicyReference(
    public val name: String,
    public val path: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.CustomerManagedPolicyAttachmentCustomerManagedPolicyReference):
            CustomerManagedPolicyAttachmentCustomerManagedPolicyReference =
            CustomerManagedPolicyAttachmentCustomerManagedPolicyReference(
                name = javaType.name(),
                path = javaType.path().map({ args0 -> args0 }).orElse(null),
            )
    }
}
