@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Cache].
 */
@PulumiTagMarker
public class CacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CacheArgs = CacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CacheArgsBuilder.() -> Unit) {
        val builder = CacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cache {
        val builtJavaResource = com.pulumi.aws.storagegateway.Cache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cache(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway cache.
 * > **NOTE:** The Storage Gateway API provides no method to remove a cache disk. Destroying this resource does not perform any Storage Gateway actions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Cache;
 * import com.pulumi.aws.storagegateway.CacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cache("example", CacheArgs.builder()
 *             .diskId(data.aws_storagegateway_local_disk().example().id())
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_cache` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/cache:Cache example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 *
 */
public class Cache internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.Cache,
) : KotlinCustomResource(javaResource, CacheMapper) {
    /**
     * Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })
}

public object CacheMapper : ResourceMapper<Cache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.Cache::class == javaResource::class

    override fun map(javaResource: Resource): Cache = Cache(
        javaResource as
            com.pulumi.aws.storagegateway.Cache,
    )
}

/**
 * @see [Cache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cache].
 */
public suspend fun cache(name: String, block: suspend CacheResourceBuilder.() -> Unit): Cache {
    val builder = CacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cache(name: String): Cache {
    val builder = CacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
