@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway cached iSCSI volume.
 * > **NOTE:** The gateway must have cache added (e.g., via the `aws.storagegateway.Cache` resource) before creating volumes otherwise the Storage Gateway API will return an error.
 * > **NOTE:** The gateway must have an upload buffer added (e.g., via the `aws.storagegateway.UploadBuffer` resource) before the volume is operational to clients, however the Storage Gateway API will allow volume creation without error in that case and return volume status as `UPLOAD BUFFER NOT CONFIGURED`.
 * ## Example Usage
 * > **NOTE:** These examples are referencing the `aws.storagegateway.Cache` resource `gateway_arn` attribute to ensure this provider properly adds cache before creating the volume. If you are not using this method, you may need to declare an expicit dependency (e.g. via `depends_on = [aws_storagegateway_cache&#46;example]`) to ensure proper ordering.
 * ### Create Empty Cached iSCSI Volume
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolume;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachesIscsiVolume("example", CachesIscsiVolumeArgs.builder()
 *             .gatewayArn(aws_storagegateway_cache.example().gateway_arn())
 *             .networkInterfaceId(aws_instance.example().private_ip())
 *             .targetName("example")
 *             .volumeSizeInBytes(5368709120)
 *             .build());
 *     }
 * }
 * ```
 * ### Create Cached iSCSI Volume From Snapshot
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolume;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachesIscsiVolume("example", CachesIscsiVolumeArgs.builder()
 *             .gatewayArn(aws_storagegateway_cache.example().gateway_arn())
 *             .networkInterfaceId(aws_instance.example().private_ip())
 *             .snapshotId(aws_ebs_snapshot.example().id())
 *             .targetName("example")
 *             .volumeSizeInBytes(aws_ebs_snapshot.example().volume_size() * 1024 * 1024 * 1024)
 *             .build());
 *     }
 * }
 * ```
 * ### Create Cached iSCSI Volume From Source Volume
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolume;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachesIscsiVolume("example", CachesIscsiVolumeArgs.builder()
 *             .gatewayArn(aws_storagegateway_cache.example().gateway_arn())
 *             .networkInterfaceId(aws_instance.example().private_ip())
 *             .sourceVolumeArn(aws_storagegateway_cached_iscsi_volume.existing().arn())
 *             .targetName("example")
 *             .volumeSizeInBytes(aws_storagegateway_cached_iscsi_volume.existing().volume_size_in_bytes())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_cached_iscsi_volume` using the volume Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/cachesIscsiVolume:CachesIscsiVolume example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678
 * ```
 * @property gatewayArn The Amazon Resource Name (ARN) of the gateway.
 * @property kmsEncrypted Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
 * @property kmsKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
 * @property networkInterfaceId The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
 * @property snapshotId The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
 * @property sourceVolumeArn The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetName The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
 * @property volumeSizeInBytes The size of the volume in bytes.
 */
public data class CachesIscsiVolumeArgs(
    public val gatewayArn: Output<String>? = null,
    public val kmsEncrypted: Output<Boolean>? = null,
    public val kmsKey: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val sourceVolumeArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetName: Output<String>? = null,
    public val volumeSizeInBytes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs =
        com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs.builder()
            .gatewayArn(gatewayArn?.applyValue({ args0 -> args0 }))
            .kmsEncrypted(kmsEncrypted?.applyValue({ args0 -> args0 }))
            .kmsKey(kmsKey?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .sourceVolumeArn(sourceVolumeArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetName(targetName?.applyValue({ args0 -> args0 }))
            .volumeSizeInBytes(volumeSizeInBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CachesIscsiVolumeArgs].
 */
@PulumiTagMarker
public class CachesIscsiVolumeArgsBuilder internal constructor() {
    private var gatewayArn: Output<String>? = null

    private var kmsEncrypted: Output<Boolean>? = null

    private var kmsKey: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var sourceVolumeArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetName: Output<String>? = null

    private var volumeSizeInBytes: Output<Int>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("kfepqldsuvrcyudm")
    public suspend fun gatewayArn(`value`: Output<String>) {
        this.gatewayArn = value
    }

    /**
     * @param value Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
     */
    @JvmName("rqtclrfacnxudafw")
    public suspend fun kmsEncrypted(`value`: Output<Boolean>) {
        this.kmsEncrypted = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
     */
    @JvmName("jlpjusbgxecpqlvs")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     */
    @JvmName("xqsmqraoaqpgselp")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
     */
    @JvmName("ofcjgjfnwckokygf")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
     */
    @JvmName("npirqtnjryweatkq")
    public suspend fun sourceVolumeArn(`value`: Output<String>) {
        this.sourceVolumeArn = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qnmxqpokigtcugrc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     */
    @JvmName("fdloasmseaqajesd")
    public suspend fun targetName(`value`: Output<String>) {
        this.targetName = value
    }

    /**
     * @param value The size of the volume in bytes.
     */
    @JvmName("yvptajaymemtdjll")
    public suspend fun volumeSizeInBytes(`value`: Output<Int>) {
        this.volumeSizeInBytes = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("rotbquhhjxnbwsfe")
    public suspend fun gatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayArn = mapped
    }

    /**
     * @param value Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
     */
    @JvmName("extlmggxrvbgedrc")
    public suspend fun kmsEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncrypted = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
     */
    @JvmName("uftxqtviysrnnrow")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    /**
     * @param value The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     */
    @JvmName("ipoobljmlgoftfmg")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
     */
    @JvmName("uvaonndwuhrclkvi")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
     */
    @JvmName("pfrdptstvlajcofv")
    public suspend fun sourceVolumeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVolumeArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ewbkcgqgymhpqoth")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mcgvwaofpnhyudie")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     */
    @JvmName("gemrdspirmclbmfg")
    public suspend fun targetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    /**
     * @param value The size of the volume in bytes.
     */
    @JvmName("kiiashulapubuide")
    public suspend fun volumeSizeInBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSizeInBytes = mapped
    }

    internal fun build(): CachesIscsiVolumeArgs = CachesIscsiVolumeArgs(
        gatewayArn = gatewayArn,
        kmsEncrypted = kmsEncrypted,
        kmsKey = kmsKey,
        networkInterfaceId = networkInterfaceId,
        snapshotId = snapshotId,
        sourceVolumeArn = sourceVolumeArn,
        tags = tags,
        targetName = targetName,
        volumeSizeInBytes = volumeSizeInBytes,
    )
}
