@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.kotlin.outputs.GatewayGatewayNetworkInterface
import com.pulumi.aws.storagegateway.kotlin.outputs.GatewayMaintenanceStartTime
import com.pulumi.aws.storagegateway.kotlin.outputs.GatewaySmbActiveDirectorySettings
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.storagegateway.kotlin.outputs.GatewayGatewayNetworkInterface.Companion.toKotlin as gatewayGatewayNetworkInterfaceToKotlin
import com.pulumi.aws.storagegateway.kotlin.outputs.GatewayMaintenanceStartTime.Companion.toKotlin as gatewayMaintenanceStartTimeToKotlin
import com.pulumi.aws.storagegateway.kotlin.outputs.GatewaySmbActiveDirectorySettings.Companion.toKotlin as gatewaySmbActiveDirectorySettingsToKotlin

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource = com.pulumi.aws.storagegateway.Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gateway(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway file, tape, or volume gateway in the provider region.
 * > **NOTE:** The Storage Gateway API requires the gateway to be connected to properly return information after activation. If you are receiving `The specified gateway is not connected` errors during resource creation (gateway activation), ensure your gateway instance meets the [Storage Gateway requirements](https://docs.aws.amazon.com/storagegateway/latest/userguide/Requirements.html).
 * ## Example Usage
 * ### Local Cache
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VolumeAttachment;
 * import com.pulumi.aws.ec2.VolumeAttachmentArgs;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.Cache;
 * import com.pulumi.aws.storagegateway.CacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testVolumeAttachment = new VolumeAttachment("testVolumeAttachment", VolumeAttachmentArgs.builder()
 *             .deviceName("/dev/xvdb")
 *             .volumeId(aws_ebs_volume.test().id())
 *             .instanceId(aws_instance.test().id())
 *             .build());
 *         final var testLocalDisk = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(testVolumeAttachment.deviceName())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *         var testCache = new Cache("testCache", CacheArgs.builder()
 *             .diskId(testLocalDisk.applyValue(getLocalDiskResult -> getLocalDiskResult).applyValue(testLocalDisk -> testLocalDisk.applyValue(getLocalDiskResult -> getLocalDiskResult.diskId())))
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### FSx File Gateway
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import com.pulumi.aws.storagegateway.inputs.GatewaySmbActiveDirectorySettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("FILE_FSX_SMB")
 *             .smbActiveDirectorySettings(GatewaySmbActiveDirectorySettingsArgs.builder()
 *                 .domainName("corp.example.com")
 *                 .password("avoid-plaintext-passwords")
 *                 .username("Admin")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### S3 File Gateway
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("FILE_S3")
 *             .build());
 *     }
 * }
 * ```
 * ### Tape Gateway
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("VTL")
 *             .mediumChangerType("AWS-Gateway-VTL")
 *             .tapeDriveType("IBM-ULT3580-TD5")
 *             .build());
 *     }
 * }
 * ```
 * ### Volume Gateway (Cached)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("CACHED")
 *             .build());
 *     }
 * }
 * ```
 * ### Volume Gateway (Stored)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("STORED")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_gateway` using the gateway Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/gateway:Gateway example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678
 * ```
 *  Certain resource arguments, like `gateway_ip_address` do not have a Storage Gateway API method for reading the information after creation, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     */
    public val activationKey: Output<String>
        get() = javaResource.activationKey().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the gateway.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     */
    public val averageDownloadRateLimitInBitsPerSec: Output<Int>?
        get() = javaResource.averageDownloadRateLimitInBitsPerSec().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     */
    public val averageUploadRateLimitInBitsPerSec: Output<Int>?
        get() = javaResource.averageUploadRateLimitInBitsPerSec().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
     */
    public val cloudwatchLogGroupArn: Output<String>?
        get() = javaResource.cloudwatchLogGroupArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    public val ec2InstanceId: Output<String>
        get() = javaResource.ec2InstanceId().applyValue({ args0 -> args0 })

    /**
     * The type of endpoint for your gateway.
     */
    public val endpointType: Output<String>
        get() = javaResource.endpointType().applyValue({ args0 -> args0 })

    /**
     * Identifier of the gateway.
     */
    public val gatewayId: Output<String>
        get() = javaResource.gatewayId().applyValue({ args0 -> args0 })

    /**
     * Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     */
    public val gatewayIpAddress: Output<String>
        get() = javaResource.gatewayIpAddress().applyValue({ args0 -> args0 })

    /**
     * Name of the gateway.
     */
    public val gatewayName: Output<String>
        get() = javaResource.gatewayName().applyValue({ args0 -> args0 })

    /**
     * An array that contains descriptions of the gateway network interfaces. See Gateway Network Interface.
     */
    public val gatewayNetworkInterfaces: Output<List<GatewayGatewayNetworkInterface>>
        get() = javaResource.gatewayNetworkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gatewayGatewayNetworkInterfaceToKotlin(args0) })
            })
        })

    /**
     * Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
     */
    public val gatewayTimezone: Output<String>
        get() = javaResource.gatewayTimezone().applyValue({ args0 -> args0 })

    /**
     * Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
     */
    public val gatewayType: Output<String>?
        get() = javaResource.gatewayType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
     */
    public val gatewayVpcEndpoint: Output<String>?
        get() = javaResource.gatewayVpcEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of hypervisor environment used by the host.
     */
    public val hostEnvironment: Output<String>
        get() = javaResource.hostEnvironment().applyValue({ args0 -> args0 })

    /**
     * The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
     */
    public val maintenanceStartTime: Output<GatewayMaintenanceStartTime>
        get() = javaResource.maintenanceStartTime().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayMaintenanceStartTimeToKotlin(args0)
            })
        })

    /**
     * Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
     */
    public val mediumChangerType: Output<String>?
        get() = javaResource.mediumChangerType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
     */
    public val smbActiveDirectorySettings: Output<GatewaySmbActiveDirectorySettings>?
        get() = javaResource.smbActiveDirectorySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gatewaySmbActiveDirectorySettingsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies whether the shares on this gateway appear when listing shares.
     */
    public val smbFileShareVisibility: Output<Boolean>?
        get() = javaResource.smbFileShareVisibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
     */
    public val smbGuestPassword: Output<String>?
        get() = javaResource.smbGuestPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
     */
    public val smbSecurityStrategy: Output<String>
        get() = javaResource.smbSecurityStrategy().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
     */
    public val tapeDriveType: Output<String>?
        get() = javaResource.tapeDriveType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.aws.storagegateway.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit):
    Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
