@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.GatewayArgs.builder
import com.pulumi.aws.storagegateway.kotlin.inputs.GatewayMaintenanceStartTimeArgs
import com.pulumi.aws.storagegateway.kotlin.inputs.GatewayMaintenanceStartTimeArgsBuilder
import com.pulumi.aws.storagegateway.kotlin.inputs.GatewaySmbActiveDirectorySettingsArgs
import com.pulumi.aws.storagegateway.kotlin.inputs.GatewaySmbActiveDirectorySettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway file, tape, or volume gateway in the provider region.
 * > **NOTE:** The Storage Gateway API requires the gateway to be connected to properly return information after activation. If you are receiving `The specified gateway is not connected` errors during resource creation (gateway activation), ensure your gateway instance meets the [Storage Gateway requirements](https://docs.aws.amazon.com/storagegateway/latest/userguide/Requirements.html).
 * ## Example Usage
 * ### Local Cache
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VolumeAttachment;
 * import com.pulumi.aws.ec2.VolumeAttachmentArgs;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.Cache;
 * import com.pulumi.aws.storagegateway.CacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testVolumeAttachment = new VolumeAttachment("testVolumeAttachment", VolumeAttachmentArgs.builder()
 *             .deviceName("/dev/xvdb")
 *             .volumeId(aws_ebs_volume.test().id())
 *             .instanceId(aws_instance.test().id())
 *             .build());
 *         final var testLocalDisk = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(testVolumeAttachment.deviceName())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *         var testCache = new Cache("testCache", CacheArgs.builder()
 *             .diskId(testLocalDisk.applyValue(getLocalDiskResult -> getLocalDiskResult).applyValue(testLocalDisk -> testLocalDisk.applyValue(getLocalDiskResult -> getLocalDiskResult.diskId())))
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### FSx File Gateway
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import com.pulumi.aws.storagegateway.inputs.GatewaySmbActiveDirectorySettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("FILE_FSX_SMB")
 *             .smbActiveDirectorySettings(GatewaySmbActiveDirectorySettingsArgs.builder()
 *                 .domainName("corp.example.com")
 *                 .password("avoid-plaintext-passwords")
 *                 .username("Admin")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### S3 File Gateway
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("FILE_S3")
 *             .build());
 *     }
 * }
 * ```
 * ### Tape Gateway
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("VTL")
 *             .mediumChangerType("AWS-Gateway-VTL")
 *             .tapeDriveType("IBM-ULT3580-TD5")
 *             .build());
 *     }
 * }
 * ```
 * ### Volume Gateway (Cached)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("CACHED")
 *             .build());
 *     }
 * }
 * ```
 * ### Volume Gateway (Stored)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.Gateway;
 * import com.pulumi.aws.storagegateway.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .gatewayIpAddress("1.2.3.4")
 *             .gatewayName("example")
 *             .gatewayTimezone("GMT")
 *             .gatewayType("STORED")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_gateway` using the gateway Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/gateway:Gateway example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678
 * ```
 *  Certain resource arguments, like `gateway_ip_address` do not have a Storage Gateway API method for reading the information after creation, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property activationKey Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
 * @property averageDownloadRateLimitInBitsPerSec The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
 * @property averageUploadRateLimitInBitsPerSec The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
 * @property cloudwatchLogGroupArn The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
 * @property gatewayIpAddress Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
 * @property gatewayName Name of the gateway.
 * @property gatewayTimezone Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
 * @property gatewayType Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
 * @property gatewayVpcEndpoint VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
 * @property maintenanceStartTime The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
 * @property mediumChangerType Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
 * @property smbActiveDirectorySettings Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
 * @property smbFileShareVisibility Specifies whether the shares on this gateway appear when listing shares.
 * @property smbGuestPassword Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
 * @property smbSecurityStrategy Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tapeDriveType Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
 */
public data class GatewayArgs(
    public val activationKey: Output<String>? = null,
    public val averageDownloadRateLimitInBitsPerSec: Output<Int>? = null,
    public val averageUploadRateLimitInBitsPerSec: Output<Int>? = null,
    public val cloudwatchLogGroupArn: Output<String>? = null,
    public val gatewayIpAddress: Output<String>? = null,
    public val gatewayName: Output<String>? = null,
    public val gatewayTimezone: Output<String>? = null,
    public val gatewayType: Output<String>? = null,
    public val gatewayVpcEndpoint: Output<String>? = null,
    public val maintenanceStartTime: Output<GatewayMaintenanceStartTimeArgs>? = null,
    public val mediumChangerType: Output<String>? = null,
    public val smbActiveDirectorySettings: Output<GatewaySmbActiveDirectorySettingsArgs>? = null,
    public val smbFileShareVisibility: Output<Boolean>? = null,
    public val smbGuestPassword: Output<String>? = null,
    public val smbSecurityStrategy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tapeDriveType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.GatewayArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.GatewayArgs =
        com.pulumi.aws.storagegateway.GatewayArgs.builder()
            .activationKey(activationKey?.applyValue({ args0 -> args0 }))
            .averageDownloadRateLimitInBitsPerSec(
                averageDownloadRateLimitInBitsPerSec?.applyValue({ args0 ->
                    args0
                }),
            )
            .averageUploadRateLimitInBitsPerSec(
                averageUploadRateLimitInBitsPerSec?.applyValue({ args0 ->
                    args0
                }),
            )
            .cloudwatchLogGroupArn(cloudwatchLogGroupArn?.applyValue({ args0 -> args0 }))
            .gatewayIpAddress(gatewayIpAddress?.applyValue({ args0 -> args0 }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .gatewayTimezone(gatewayTimezone?.applyValue({ args0 -> args0 }))
            .gatewayType(gatewayType?.applyValue({ args0 -> args0 }))
            .gatewayVpcEndpoint(gatewayVpcEndpoint?.applyValue({ args0 -> args0 }))
            .maintenanceStartTime(
                maintenanceStartTime?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mediumChangerType(mediumChangerType?.applyValue({ args0 -> args0 }))
            .smbActiveDirectorySettings(
                smbActiveDirectorySettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .smbFileShareVisibility(smbFileShareVisibility?.applyValue({ args0 -> args0 }))
            .smbGuestPassword(smbGuestPassword?.applyValue({ args0 -> args0 }))
            .smbSecurityStrategy(smbSecurityStrategy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tapeDriveType(tapeDriveType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var activationKey: Output<String>? = null

    private var averageDownloadRateLimitInBitsPerSec: Output<Int>? = null

    private var averageUploadRateLimitInBitsPerSec: Output<Int>? = null

    private var cloudwatchLogGroupArn: Output<String>? = null

    private var gatewayIpAddress: Output<String>? = null

    private var gatewayName: Output<String>? = null

    private var gatewayTimezone: Output<String>? = null

    private var gatewayType: Output<String>? = null

    private var gatewayVpcEndpoint: Output<String>? = null

    private var maintenanceStartTime: Output<GatewayMaintenanceStartTimeArgs>? = null

    private var mediumChangerType: Output<String>? = null

    private var smbActiveDirectorySettings: Output<GatewaySmbActiveDirectorySettingsArgs>? = null

    private var smbFileShareVisibility: Output<Boolean>? = null

    private var smbGuestPassword: Output<String>? = null

    private var smbSecurityStrategy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tapeDriveType: Output<String>? = null

    /**
     * @param value Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     */
    @JvmName("urtwhvkplmiasomn")
    public suspend fun activationKey(`value`: Output<String>) {
        this.activationKey = value
    }

    /**
     * @param value The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     */
    @JvmName("sdldonljcuhmqbld")
    public suspend fun averageDownloadRateLimitInBitsPerSec(`value`: Output<Int>) {
        this.averageDownloadRateLimitInBitsPerSec = value
    }

    /**
     * @param value The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     */
    @JvmName("qrwvrnexexxqujvw")
    public suspend fun averageUploadRateLimitInBitsPerSec(`value`: Output<Int>) {
        this.averageUploadRateLimitInBitsPerSec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
     */
    @JvmName("bjovqdnafydftbeh")
    public suspend fun cloudwatchLogGroupArn(`value`: Output<String>) {
        this.cloudwatchLogGroupArn = value
    }

    /**
     * @param value Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     */
    @JvmName("vmixqfsosaifaxdx")
    public suspend fun gatewayIpAddress(`value`: Output<String>) {
        this.gatewayIpAddress = value
    }

    /**
     * @param value Name of the gateway.
     */
    @JvmName("xiqtpxyerwxbidud")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
     */
    @JvmName("xptcfknqugroboai")
    public suspend fun gatewayTimezone(`value`: Output<String>) {
        this.gatewayTimezone = value
    }

    /**
     * @param value Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
     */
    @JvmName("oisxwebqvhmtjkow")
    public suspend fun gatewayType(`value`: Output<String>) {
        this.gatewayType = value
    }

    /**
     * @param value VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
     */
    @JvmName("fxvvtorgmbmlgmrx")
    public suspend fun gatewayVpcEndpoint(`value`: Output<String>) {
        this.gatewayVpcEndpoint = value
    }

    /**
     * @param value The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
     */
    @JvmName("lbdvnlsqovbmnpjn")
    public suspend fun maintenanceStartTime(`value`: Output<GatewayMaintenanceStartTimeArgs>) {
        this.maintenanceStartTime = value
    }

    /**
     * @param value Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
     */
    @JvmName("pdenqypuyvuyqeic")
    public suspend fun mediumChangerType(`value`: Output<String>) {
        this.mediumChangerType = value
    }

    /**
     * @param value Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
     */
    @JvmName("jxiqphqjunswajgg")
    public suspend
    fun smbActiveDirectorySettings(`value`: Output<GatewaySmbActiveDirectorySettingsArgs>) {
        this.smbActiveDirectorySettings = value
    }

    /**
     * @param value Specifies whether the shares on this gateway appear when listing shares.
     */
    @JvmName("uufyktpyjiuneeey")
    public suspend fun smbFileShareVisibility(`value`: Output<Boolean>) {
        this.smbFileShareVisibility = value
    }

    /**
     * @param value Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
     */
    @JvmName("jfnkokwwdxhauhkw")
    public suspend fun smbGuestPassword(`value`: Output<String>) {
        this.smbGuestPassword = value
    }

    /**
     * @param value Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
     */
    @JvmName("atthxaxbfkwqktkh")
    public suspend fun smbSecurityStrategy(`value`: Output<String>) {
        this.smbSecurityStrategy = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ylsxpwyigfkwxpqc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
     */
    @JvmName("ntbbidfjlhjrcaxd")
    public suspend fun tapeDriveType(`value`: Output<String>) {
        this.tapeDriveType = value
    }

    /**
     * @param value Gateway activation key during resource creation. Conflicts with `gateway_ip_address`. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     */
    @JvmName("lnlfqwbpkuedfbkw")
    public suspend fun activationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activationKey = mapped
    }

    /**
     * @param value The average download bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     */
    @JvmName("oanufdawviglbcif")
    public suspend fun averageDownloadRateLimitInBitsPerSec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.averageDownloadRateLimitInBitsPerSec = mapped
    }

    /**
     * @param value The average upload bandwidth rate limit in bits per second. This is supported for the `CACHED`, `STORED`, and `VTL` gateway types.
     */
    @JvmName("fkwhfvjofltxoele")
    public suspend fun averageUploadRateLimitInBitsPerSec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.averageUploadRateLimitInBitsPerSec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Amazon CloudWatch log group to use to monitor and log events in the gateway.
     */
    @JvmName("mtruswhriecrdwnq")
    public suspend fun cloudwatchLogGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogGroupArn = mapped
    }

    /**
     * @param value Gateway IP address to retrieve activation key during resource creation. Conflicts with `activation_key`. Gateway must be accessible on port 80 from where this provider is running. Additional information is available in the [Storage Gateway User Guide](https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html).
     */
    @JvmName("ymrwbmhnyxsuxhfr")
    public suspend fun gatewayIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayIpAddress = mapped
    }

    /**
     * @param value Name of the gateway.
     */
    @JvmName("nefylermpxnxvwoj")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value Time zone for the gateway. The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For example, `GMT-4:00` indicates the time is 4 hours behind GMT. The time zone is used, for example, for scheduling snapshots and your gateway's maintenance schedule.
     */
    @JvmName("cuewleqwhoouuwrt")
    public suspend fun gatewayTimezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayTimezone = mapped
    }

    /**
     * @param value Type of the gateway. The default value is `STORED`. Valid values: `CACHED`, `FILE_FSX_SMB`, `FILE_S3`, `STORED`, `VTL`.
     */
    @JvmName("ojnnfycngmjitjkd")
    public suspend fun gatewayType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value VPC endpoint address to be used when activating your gateway. This should be used when your instance is in a private subnet. Requires HTTP access from client computer running this provider. More info on what ports are required by your VPC Endpoint Security group in [Activating a Gateway in a Virtual Private Cloud](https://docs.aws.amazon.com/storagegateway/latest/userguide/gateway-private-link.html).
     */
    @JvmName("duialoqrwvwbaumb")
    public suspend fun gatewayVpcEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayVpcEndpoint = mapped
    }

    /**
     * @param value The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
     */
    @JvmName("gjtvxiauoubycemm")
    public suspend fun maintenanceStartTime(`value`: GatewayMaintenanceStartTimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceStartTime = mapped
    }

    /**
     * @param argument The gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone. More details below.
     */
    @JvmName("mdhdtnxcsofvmapq")
    public suspend
    fun maintenanceStartTime(argument: suspend GatewayMaintenanceStartTimeArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayMaintenanceStartTimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenanceStartTime = mapped
    }

    /**
     * @param value Type of medium changer to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `STK-L700`, `AWS-Gateway-VTL`, `IBM-03584L32-0402`.
     */
    @JvmName("flblqjkquytwreru")
    public suspend fun mediumChangerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediumChangerType = mapped
    }

    /**
     * @param value Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
     */
    @JvmName("uyfbvxpgjuhqdrmc")
    public suspend fun smbActiveDirectorySettings(`value`: GatewaySmbActiveDirectorySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbActiveDirectorySettings = mapped
    }

    /**
     * @param argument Nested argument with Active Directory domain join information for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `ActiveDirectory` authentication SMB file shares. More details below.
     */
    @JvmName("nygkvdwhbjvfspxv")
    public suspend
    fun smbActiveDirectorySettings(argument: suspend GatewaySmbActiveDirectorySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = GatewaySmbActiveDirectorySettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.smbActiveDirectorySettings = mapped
    }

    /**
     * @param value Specifies whether the shares on this gateway appear when listing shares.
     */
    @JvmName("nhfdgdedusswjghs")
    public suspend fun smbFileShareVisibility(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbFileShareVisibility = mapped
    }

    /**
     * @param value Guest password for Server Message Block (SMB) file shares. Only valid for `FILE_S3` and `FILE_FSX_SMB` gateway types. Must be set before creating `GuestAccess` authentication SMB file shares. This provider can only detect drift of the existence of a guest password, not its actual value from the gateway. This provider can however update the password with changing the argument.
     */
    @JvmName("mroddyudciiuftlo")
    public suspend fun smbGuestPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbGuestPassword = mapped
    }

    /**
     * @param value Specifies the type of security strategy. Valid values are: `ClientSpecified`, `MandatorySigning`, and `MandatoryEncryption`. See [Setting a Security Level for Your Gateway](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-gateway-file.html#security-strategy) for more information.
     */
    @JvmName("qqrpvegxuchiqfxu")
    public suspend fun smbSecurityStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbSecurityStrategy = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rbrmifkhnadxdbxt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qssqnvefstdumtdc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of tape drive to use for tape gateway. This provider cannot detect drift of this argument. Valid values: `IBM-ULT3580-TD5`.
     */
    @JvmName("pwbaljrhtcmkctvv")
    public suspend fun tapeDriveType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tapeDriveType = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        activationKey = activationKey,
        averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec,
        averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec,
        cloudwatchLogGroupArn = cloudwatchLogGroupArn,
        gatewayIpAddress = gatewayIpAddress,
        gatewayName = gatewayName,
        gatewayTimezone = gatewayTimezone,
        gatewayType = gatewayType,
        gatewayVpcEndpoint = gatewayVpcEndpoint,
        maintenanceStartTime = maintenanceStartTime,
        mediumChangerType = mediumChangerType,
        smbActiveDirectorySettings = smbActiveDirectorySettings,
        smbFileShareVisibility = smbFileShareVisibility,
        smbGuestPassword = smbGuestPassword,
        smbSecurityStrategy = smbSecurityStrategy,
        tags = tags,
        tapeDriveType = tapeDriveType,
    )
}
