@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.kotlin.outputs.NfsFileShareCacheAttributes
import com.pulumi.aws.storagegateway.kotlin.outputs.NfsFileShareNfsFileShareDefaults
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.storagegateway.kotlin.outputs.NfsFileShareCacheAttributes.Companion.toKotlin as nfsFileShareCacheAttributesToKotlin
import com.pulumi.aws.storagegateway.kotlin.outputs.NfsFileShareNfsFileShareDefaults.Companion.toKotlin as nfsFileShareNfsFileShareDefaultsToKotlin

/**
 * Builder for [NfsFileShare].
 */
@PulumiTagMarker
public class NfsFileShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NfsFileShareArgs = NfsFileShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NfsFileShareArgsBuilder.() -> Unit) {
        val builder = NfsFileShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NfsFileShare {
        val builtJavaResource = com.pulumi.aws.storagegateway.NfsFileShare(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NfsFileShare(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway NFS File Share.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.NfsFileShare;
 * import com.pulumi.aws.storagegateway.NfsFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NfsFileShare("example", NfsFileShareArgs.builder()
 *             .clientLists("0.0.0.0/0")
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .locationArn(aws_s3_bucket.example().arn())
 *             .roleArn(aws_iam_role.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_nfs_file_share` using the NFS File Share Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/nfsFileShare:NfsFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
 * ```
 *
 */
public class NfsFileShare internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.NfsFileShare,
) : KotlinCustomResource(javaResource, NfsFileShareMapper) {
    /**
     * Amazon Resource Name (ARN) of the NFS File Share.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public val auditDestinationArn: Output<String>?
        get() = javaResource.auditDestinationArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region of the S3 bucket used by the file share. Required when specifying `vpc_endpoint_dns_name`.
     */
    public val bucketRegion: Output<String>?
        get() = javaResource.bucketRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Refresh cache information. see Cache Attributes for more details.
     */
    public val cacheAttributes: Output<NfsFileShareCacheAttributes>?
        get() = javaResource.cacheAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nfsFileShareCacheAttributesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0&#46;0&#46;0&#46;0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
     */
    public val clientLists: Output<List<String>>
        get() = javaResource.clientLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     */
    public val defaultStorageClass: Output<String>?
        get() = javaResource.defaultStorageClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     */
    public val fileShareName: Output<String>
        get() = javaResource.fileShareName().applyValue({ args0 -> args0 })

    /**
     * ID of the NFS File Share.
     */
    public val fileshareId: Output<String>
        get() = javaResource.fileshareId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the file gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })

    /**
     * Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     */
    public val guessMimeTypeEnabled: Output<Boolean>?
        get() = javaResource.guessMimeTypeEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     */
    public val kmsEncrypted: Output<Boolean>?
        get() = javaResource.kmsEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     */
    public val kmsKeyArn: Output<String>?
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ARN of the backed storage used for storing file data.
     */
    public val locationArn: Output<String>
        get() = javaResource.locationArn().applyValue({ args0 -> args0 })

    /**
     * Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
     */
    public val nfsFileShareDefaults: Output<NfsFileShareNfsFileShareDefaults>?
        get() = javaResource.nfsFileShareDefaults().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nfsFileShareNfsFileShareDefaultsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     */
    public val notificationPolicy: Output<String>?
        get() = javaResource.notificationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Access Control List permission for S3 objects. Defaults to `private`.
     */
    public val objectAcl: Output<String>?
        get() = javaResource.objectAcl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * File share path used by the NFS client to identify the mount point.
     */
    public val path: Output<String>
        get() = javaResource.path().applyValue({ args0 -> args0 })

    /**
     * Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     */
    public val readOnly: Output<Boolean>?
        get() = javaResource.readOnly().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     */
    public val requesterPays: Output<Boolean>?
        get() = javaResource.requesterPays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
     */
    public val squash: Output<String>?
        get() = javaResource.squash().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The DNS name of the VPC endpoint for S3 PrivateLink.
     */
    public val vpcEndpointDnsName: Output<String>?
        get() = javaResource.vpcEndpointDnsName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NfsFileShareMapper : ResourceMapper<NfsFileShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.NfsFileShare::class == javaResource::class

    override fun map(javaResource: Resource): NfsFileShare = NfsFileShare(
        javaResource as
            com.pulumi.aws.storagegateway.NfsFileShare,
    )
}

/**
 * @see [NfsFileShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NfsFileShare].
 */
public suspend fun nfsFileShare(
    name: String,
    block: suspend NfsFileShareResourceBuilder.() -> Unit,
): NfsFileShare {
    val builder = NfsFileShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NfsFileShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nfsFileShare(name: String): NfsFileShare {
    val builder = NfsFileShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
