@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.StoragegatewayFunctions.getLocalDiskPlain
import com.pulumi.aws.storagegateway.kotlin.inputs.GetLocalDiskPlainArgs
import com.pulumi.aws.storagegateway.kotlin.inputs.GetLocalDiskPlainArgsBuilder
import com.pulumi.aws.storagegateway.kotlin.outputs.GetLocalDiskResult
import com.pulumi.aws.storagegateway.kotlin.outputs.GetLocalDiskResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object StoragegatewayFunctions {
    /**
     * Retrieve information about a Storage Gateway local disk. The disk identifier is useful for adding the disk as a cache or upload buffer to a gateway.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
     * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
     *             .diskPath(aws_volume_attachment.test().device_name())
     *             .gatewayArn(aws_storagegateway_gateway.test().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocalDisk.
     * @return A collection of values returned by getLocalDisk.
     */
    public suspend fun getLocalDisk(argument: GetLocalDiskPlainArgs): GetLocalDiskResult =
        toKotlin(getLocalDiskPlain(argument.toJava()).await())

    /**
     * @see [getLocalDisk].
     * @param diskNode Device node of the local disk to retrieve. For example, `/dev/sdb`.
     * @param diskPath Device path of the local disk to retrieve. For example, `/dev/xvdb` or `/dev/nvme1n1`.
     * @param gatewayArn ARN of the gateway.
     * @return A collection of values returned by getLocalDisk.
     */
    public suspend fun getLocalDisk(
        diskNode: String? = null,
        diskPath: String? = null,
        gatewayArn: String,
    ): GetLocalDiskResult {
        val argument = GetLocalDiskPlainArgs(
            diskNode = diskNode,
            diskPath = diskPath,
            gatewayArn = gatewayArn,
        )
        return toKotlin(getLocalDiskPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalDisk].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;storagegateway&#46;kotlin&#46;inputs&#46;GetLocalDiskPlainArgs].
     * @return A collection of values returned by getLocalDisk.
     */
    public suspend fun getLocalDisk(argument: suspend GetLocalDiskPlainArgsBuilder.() -> Unit):
        GetLocalDiskResult {
        val builder = GetLocalDiskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getLocalDiskPlain(builtArgument.toJava()).await())
    }
}
