@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway stored iSCSI volume.
 * > **NOTE:** The gateway must have a working storage added (e.g., via the `aws.storagegateway.WorkingStorage` resource) before the volume is operational to clients, however the Storage Gateway API will allow volume creation without error in that case and return volume status as `WORKING STORAGE NOT CONFIGURED`.
 * ## Example Usage
 * ### Create Empty Stored iSCSI Volume
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolume;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StoredIscsiVolume("example", StoredIscsiVolumeArgs.builder()
 *             .gatewayArn(aws_storagegateway_cache.example().gateway_arn())
 *             .networkInterfaceId(aws_instance.example().private_ip())
 *             .targetName("example")
 *             .preserveExistingData(false)
 *             .diskId(data.aws_storagegateway_local_disk().test().id())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Stored iSCSI Volume From Snapshot
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolume;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StoredIscsiVolume("example", StoredIscsiVolumeArgs.builder()
 *             .gatewayArn(aws_storagegateway_cache.example().gateway_arn())
 *             .networkInterfaceId(aws_instance.example().private_ip())
 *             .snapshotId(aws_ebs_snapshot.example().id())
 *             .targetName("example")
 *             .preserveExistingData(false)
 *             .diskId(data.aws_storagegateway_local_disk().test().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_stored_iscsi_volume` using the volume Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/storedIscsiVolume:StoredIscsiVolume example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678
 * ```
 * @property diskId The unique identifier for the gateway local disk that is configured as a stored volume.
 * @property gatewayArn The Amazon Resource Name (ARN) of the gateway.
 * @property kmsEncrypted `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
 * @property kmsKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
 * @property networkInterfaceId The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
 * @property preserveExistingData Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
 * @property snapshotId The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
 * @property tags Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetName The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
 */
public data class StoredIscsiVolumeArgs(
    public val diskId: Output<String>? = null,
    public val gatewayArn: Output<String>? = null,
    public val kmsEncrypted: Output<Boolean>? = null,
    public val kmsKey: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val preserveExistingData: Output<Boolean>? = null,
    public val snapshotId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs =
        com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs.builder()
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .gatewayArn(gatewayArn?.applyValue({ args0 -> args0 }))
            .kmsEncrypted(kmsEncrypted?.applyValue({ args0 -> args0 }))
            .kmsKey(kmsKey?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .preserveExistingData(preserveExistingData?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetName(targetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StoredIscsiVolumeArgs].
 */
@PulumiTagMarker
public class StoredIscsiVolumeArgsBuilder internal constructor() {
    private var diskId: Output<String>? = null

    private var gatewayArn: Output<String>? = null

    private var kmsEncrypted: Output<Boolean>? = null

    private var kmsKey: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var preserveExistingData: Output<Boolean>? = null

    private var snapshotId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetName: Output<String>? = null

    /**
     * @param value The unique identifier for the gateway local disk that is configured as a stored volume.
     */
    @JvmName("qyafqsjxptsaonic")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("loqtxkvgquxybcei")
    public suspend fun gatewayArn(`value`: Output<String>) {
        this.gatewayArn = value
    }

    /**
     * @param value `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
     */
    @JvmName("hkgxoueteoorysmo")
    public suspend fun kmsEncrypted(`value`: Output<Boolean>) {
        this.kmsEncrypted = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
     */
    @JvmName("wvfoshksvhbnklag")
    public suspend fun kmsKey(`value`: Output<String>) {
        this.kmsKey = value
    }

    /**
     * @param value The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     */
    @JvmName("letxhqotqhlbiidy")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
     */
    @JvmName("xdiebxaboajxwvnp")
    public suspend fun preserveExistingData(`value`: Output<Boolean>) {
        this.preserveExistingData = value
    }

    /**
     * @param value The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
     */
    @JvmName("qoyipmbxmbjrmvvq")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hnmxukjxmvupjrif")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     */
    @JvmName("ysiniomoatomvhxj")
    public suspend fun targetName(`value`: Output<String>) {
        this.targetName = value
    }

    /**
     * @param value The unique identifier for the gateway local disk that is configured as a stored volume.
     */
    @JvmName("ynealwgsdioqshnv")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("usbhpbljgtjctpfg")
    public suspend fun gatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayArn = mapped
    }

    /**
     * @param value `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
     */
    @JvmName("iqnouksmiqvcrwwn")
    public suspend fun kmsEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncrypted = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
     */
    @JvmName("mdvjmgpljmpwossa")
    public suspend fun kmsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKey = mapped
    }

    /**
     * @param value The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     */
    @JvmName("bpapnujnxlsuypjf")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
     */
    @JvmName("rfeqqioboexiejky")
    public suspend fun preserveExistingData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveExistingData = mapped
    }

    /**
     * @param value The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
     */
    @JvmName("bhhxiebchkccvdxb")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lspjxltiwjuaalir")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rutqcpsctqntojnj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     */
    @JvmName("yllnwesnnijlealp")
    public suspend fun targetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    internal fun build(): StoredIscsiVolumeArgs = StoredIscsiVolumeArgs(
        diskId = diskId,
        gatewayArn = gatewayArn,
        kmsEncrypted = kmsEncrypted,
        kmsKey = kmsKey,
        networkInterfaceId = networkInterfaceId,
        preserveExistingData = preserveExistingData,
        snapshotId = snapshotId,
        tags = tags,
        targetName = targetName,
    )
}
