@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UploadBuffer].
 */
@PulumiTagMarker
public class UploadBufferResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UploadBufferArgs = UploadBufferArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UploadBufferArgsBuilder.() -> Unit) {
        val builder = UploadBufferArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UploadBuffer {
        val builtJavaResource = com.pulumi.aws.storagegateway.UploadBuffer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UploadBuffer(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway upload buffer.
 * > **NOTE:** The Storage Gateway API provides no method to remove an upload buffer disk. Destroying this resource does not perform any Storage Gateway actions.
 * ## Example Usage
 * ### Cached and VTL Gateway Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testLocalDisk = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(aws_volume_attachment.test().device_name())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *         var testUploadBuffer = new UploadBuffer("testUploadBuffer", UploadBufferArgs.builder()
 *             .diskPath(testLocalDisk.applyValue(getLocalDiskResult -> getLocalDiskResult.diskPath()))
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Stored Gateway Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(aws_volume_attachment.test().device_name())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *         var example = new UploadBuffer("example", UploadBufferArgs.builder()
 *             .diskId(data.aws_storagegateway_local_disk().example().id())
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_upload_buffer` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/uploadBuffer:UploadBuffer example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 *
 */
public class UploadBuffer internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.UploadBuffer,
) : KotlinCustomResource(javaResource, UploadBufferMapper) {
    /**
     * Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * Local disk path. For example, `/dev/nvme1n1`.
     */
    public val diskPath: Output<String>
        get() = javaResource.diskPath().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })
}

public object UploadBufferMapper : ResourceMapper<UploadBuffer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.UploadBuffer::class == javaResource::class

    override fun map(javaResource: Resource): UploadBuffer = UploadBuffer(
        javaResource as
            com.pulumi.aws.storagegateway.UploadBuffer,
    )
}

/**
 * @see [UploadBuffer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UploadBuffer].
 */
public suspend fun uploadBuffer(
    name: String,
    block: suspend UploadBufferResourceBuilder.() -> Unit,
): UploadBuffer {
    val builder = UploadBufferResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UploadBuffer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun uploadBuffer(name: String): UploadBuffer {
    val builder = UploadBufferResourceBuilder()
    builder.name(name)
    return builder.build()
}
