@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.UploadBufferArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway upload buffer.
 * > **NOTE:** The Storage Gateway API provides no method to remove an upload buffer disk. Destroying this resource does not perform any Storage Gateway actions.
 * ## Example Usage
 * ### Cached and VTL Gateway Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var testLocalDisk = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(aws_volume_attachment.test().device_name())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *         var testUploadBuffer = new UploadBuffer("testUploadBuffer", UploadBufferArgs.builder()
 *             .diskPath(testLocalDisk.applyValue(getLocalDiskResult -> getLocalDiskResult.diskPath()))
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Stored Gateway Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(aws_volume_attachment.test().device_name())
 *             .gatewayArn(aws_storagegateway_gateway.test().arn())
 *             .build());
 *         var example = new UploadBuffer("example", UploadBufferArgs.builder()
 *             .diskId(data.aws_storagegateway_local_disk().example().id())
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_upload_buffer` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/uploadBuffer:UploadBuffer example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 * @property diskId Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
 * @property diskPath Local disk path. For example, `/dev/nvme1n1`.
 * @property gatewayArn The Amazon Resource Name (ARN) of the gateway.
 */
public data class UploadBufferArgs(
    public val diskId: Output<String>? = null,
    public val diskPath: Output<String>? = null,
    public val gatewayArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.UploadBufferArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.UploadBufferArgs =
        com.pulumi.aws.storagegateway.UploadBufferArgs.builder()
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .diskPath(diskPath?.applyValue({ args0 -> args0 }))
            .gatewayArn(gatewayArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UploadBufferArgs].
 */
@PulumiTagMarker
public class UploadBufferArgsBuilder internal constructor() {
    private var diskId: Output<String>? = null

    private var diskPath: Output<String>? = null

    private var gatewayArn: Output<String>? = null

    /**
     * @param value Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    @JvmName("kpppatfsdnnowehh")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value Local disk path. For example, `/dev/nvme1n1`.
     */
    @JvmName("noyxfnwbgqwgieym")
    public suspend fun diskPath(`value`: Output<String>) {
        this.diskPath = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("uqdpjsncuhvvdkno")
    public suspend fun gatewayArn(`value`: Output<String>) {
        this.gatewayArn = value
    }

    /**
     * @param value Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    @JvmName("ljsvbaaytsxnjfap")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value Local disk path. For example, `/dev/nvme1n1`.
     */
    @JvmName("xwcfpvpghhwvqdgl")
    public suspend fun diskPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskPath = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("xvvfnyvssrfjxnvw")
    public suspend fun gatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayArn = mapped
    }

    internal fun build(): UploadBufferArgs = UploadBufferArgs(
        diskId = diskId,
        diskPath = diskPath,
        gatewayArn = gatewayArn,
    )
}
