@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkingStorage].
 */
@PulumiTagMarker
public class WorkingStorageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkingStorageArgs = WorkingStorageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkingStorageArgsBuilder.() -> Unit) {
        val builder = WorkingStorageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkingStorage {
        val builtJavaResource = com.pulumi.aws.storagegateway.WorkingStorage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WorkingStorage(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway working storage.
 * > **NOTE:** The Storage Gateway API provides no method to remove a working storage disk. Destroying this resource does not perform any Storage Gateway actions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.WorkingStorage;
 * import com.pulumi.aws.storagegateway.WorkingStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkingStorage("example", WorkingStorageArgs.builder()
 *             .diskId(data.aws_storagegateway_local_disk().example().id())
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_working_storage` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/workingStorage:WorkingStorage example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 *
 */
public class WorkingStorage internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.WorkingStorage,
) : KotlinCustomResource(javaResource, WorkingStorageMapper) {
    /**
     * Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })
}

public object WorkingStorageMapper : ResourceMapper<WorkingStorage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.WorkingStorage::class == javaResource::class

    override fun map(javaResource: Resource): WorkingStorage = WorkingStorage(
        javaResource as
            com.pulumi.aws.storagegateway.WorkingStorage,
    )
}

/**
 * @see [WorkingStorage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkingStorage].
 */
public suspend fun workingStorage(
    name: String,
    block: suspend WorkingStorageResourceBuilder.() -> Unit,
): WorkingStorage {
    val builder = WorkingStorageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkingStorage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workingStorage(name: String): WorkingStorage {
    val builder = WorkingStorageResourceBuilder()
    builder.name(name)
    return builder.build()
}
