@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.WorkingStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway working storage.
 * > **NOTE:** The Storage Gateway API provides no method to remove a working storage disk. Destroying this resource does not perform any Storage Gateway actions.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.WorkingStorage;
 * import com.pulumi.aws.storagegateway.WorkingStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkingStorage("example", WorkingStorageArgs.builder()
 *             .diskId(data.aws_storagegateway_local_disk().example().id())
 *             .gatewayArn(aws_storagegateway_gateway.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_working_storage` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:storagegateway/workingStorage:WorkingStorage example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 * @property diskId Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
 * @property gatewayArn The Amazon Resource Name (ARN) of the gateway.
 */
public data class WorkingStorageArgs(
    public val diskId: Output<String>? = null,
    public val gatewayArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.WorkingStorageArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.WorkingStorageArgs =
        com.pulumi.aws.storagegateway.WorkingStorageArgs.builder()
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .gatewayArn(gatewayArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkingStorageArgs].
 */
@PulumiTagMarker
public class WorkingStorageArgsBuilder internal constructor() {
    private var diskId: Output<String>? = null

    private var gatewayArn: Output<String>? = null

    /**
     * @param value Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    @JvmName("jdqbialfthpltlmm")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("cflljdccbdkwpwtc")
    public suspend fun gatewayArn(`value`: Output<String>) {
        this.gatewayArn = value
    }

    /**
     * @param value Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    @JvmName("vnhvsakofogosvpb")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("igtgauljamsxmajw")
    public suspend fun gatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayArn = mapped
    }

    internal fun build(): WorkingStorageArgs = WorkingStorageArgs(
        diskId = diskId,
        gatewayArn = gatewayArn,
    )
}
