@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.inputs

import com.pulumi.aws.storagegateway.inputs.GatewaySmbActiveDirectorySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property activeDirectoryStatus
 * @property domainControllers List of IPv4 addresses, NetBIOS names, or host names of your domain server.
 * If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
 * @property domainName The name of the domain that you want the gateway to join.
 * @property organizationalUnit The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
 * computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
 * @property password The password of the user who has permission to add the gateway to the Active Directory domain.
 * @property timeoutInSeconds Specifies the time in seconds, in which the JoinDomain operation must complete. The default is `20` seconds.
 * @property username The user name of user who has permission to add the gateway to the Active Directory domain.
 */
public data class GatewaySmbActiveDirectorySettingsArgs(
    public val activeDirectoryStatus: Output<String>? = null,
    public val domainControllers: Output<List<String>>? = null,
    public val domainName: Output<String>,
    public val organizationalUnit: Output<String>? = null,
    public val password: Output<String>,
    public val timeoutInSeconds: Output<Int>? = null,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.inputs.GatewaySmbActiveDirectorySettingsArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.inputs.GatewaySmbActiveDirectorySettingsArgs =
        com.pulumi.aws.storagegateway.inputs.GatewaySmbActiveDirectorySettingsArgs.builder()
            .activeDirectoryStatus(activeDirectoryStatus?.applyValue({ args0 -> args0 }))
            .domainControllers(domainControllers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .organizationalUnit(organizationalUnit?.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewaySmbActiveDirectorySettingsArgs].
 */
@PulumiTagMarker
public class GatewaySmbActiveDirectorySettingsArgsBuilder internal constructor() {
    private var activeDirectoryStatus: Output<String>? = null

    private var domainControllers: Output<List<String>>? = null

    private var domainName: Output<String>? = null

    private var organizationalUnit: Output<String>? = null

    private var password: Output<String>? = null

    private var timeoutInSeconds: Output<Int>? = null

    private var username: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fnxwwucjyeocuogw")
    public suspend fun activeDirectoryStatus(`value`: Output<String>) {
        this.activeDirectoryStatus = value
    }

    /**
     * @param value List of IPv4 addresses, NetBIOS names, or host names of your domain server.
     * If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
     */
    @JvmName("bqsnohqlltsibhqi")
    public suspend fun domainControllers(`value`: Output<List<String>>) {
        this.domainControllers = value
    }

    @JvmName("nmxyaajlwvjkaajc")
    public suspend fun domainControllers(vararg values: Output<String>) {
        this.domainControllers = Output.all(values.asList())
    }

    /**
     * @param values List of IPv4 addresses, NetBIOS names, or host names of your domain server.
     * If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
     */
    @JvmName("ahrsnilshfhetmqp")
    public suspend fun domainControllers(values: List<Output<String>>) {
        this.domainControllers = Output.all(values)
    }

    /**
     * @param value The name of the domain that you want the gateway to join.
     */
    @JvmName("vlhkgdibcbebcxyc")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
     * computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
     */
    @JvmName("nfpuldtmtcxiighf")
    public suspend fun organizationalUnit(`value`: Output<String>) {
        this.organizationalUnit = value
    }

    /**
     * @param value The password of the user who has permission to add the gateway to the Active Directory domain.
     */
    @JvmName("aqiplstbvknhwuhn")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Specifies the time in seconds, in which the JoinDomain operation must complete. The default is `20` seconds.
     */
    @JvmName("ujdvbouurccybqhw")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value The user name of user who has permission to add the gateway to the Active Directory domain.
     */
    @JvmName("nkoqruardpoityqb")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value
     */
    @JvmName("anraryxpwiaaoxau")
    public suspend fun activeDirectoryStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryStatus = mapped
    }

    /**
     * @param value List of IPv4 addresses, NetBIOS names, or host names of your domain server.
     * If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
     */
    @JvmName("kkojggummslqtmuj")
    public suspend fun domainControllers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainControllers = mapped
    }

    /**
     * @param values List of IPv4 addresses, NetBIOS names, or host names of your domain server.
     * If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
     */
    @JvmName("dmegvwaboxpixqbk")
    public suspend fun domainControllers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainControllers = mapped
    }

    /**
     * @param value The name of the domain that you want the gateway to join.
     */
    @JvmName("tjsiptsrikgwthxh")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
     * computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
     */
    @JvmName("avwjchhvixdwyngd")
    public suspend fun organizationalUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnit = mapped
    }

    /**
     * @param value The password of the user who has permission to add the gateway to the Active Directory domain.
     */
    @JvmName("wvklqltmtqoaxicw")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Specifies the time in seconds, in which the JoinDomain operation must complete. The default is `20` seconds.
     */
    @JvmName("yiwkfqkyirjysnju")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    /**
     * @param value The user name of user who has permission to add the gateway to the Active Directory domain.
     */
    @JvmName("vfyvclhfdammcibn")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): GatewaySmbActiveDirectorySettingsArgs =
        GatewaySmbActiveDirectorySettingsArgs(
            activeDirectoryStatus = activeDirectoryStatus,
            domainControllers = domainControllers,
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            organizationalUnit = organizationalUnit,
            password = password ?: throw PulumiNullFieldException("password"),
            timeoutInSeconds = timeoutInSeconds,
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
