@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dayOfMonth The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month.
 * @property dayOfWeek The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday.
 * @property hourOfDay The hour component of the maintenance start time represented as _hh_, where _hh_ is the hour (00 to 23). The hour of the day is in the time zone of the gateway.
 * @property minuteOfHour The minute component of the maintenance start time represented as _mm_, where _mm_ is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.
 */
public data class GatewayMaintenanceStartTime(
    public val dayOfMonth: String? = null,
    public val dayOfWeek: String? = null,
    public val hourOfDay: Int,
    public val minuteOfHour: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.storagegateway.outputs.GatewayMaintenanceStartTime):
            GatewayMaintenanceStartTime = GatewayMaintenanceStartTime(
            dayOfMonth = javaType.dayOfMonth().map({ args0 -> args0 }).orElse(null),
            dayOfWeek = javaType.dayOfWeek().map({ args0 -> args0 }).orElse(null),
            hourOfDay = javaType.hourOfDay(),
            minuteOfHour = javaType.minuteOfHour().map({ args0 -> args0 }).orElse(null),
        )
    }
}
