@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getLocalDisk.
 * @property diskId Disk identifierE.g., `pci-0000:03:00.0-scsi-0:0:0:0`
 * @property diskNode
 * @property diskPath
 * @property gatewayArn
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetLocalDiskResult(
    public val diskId: String,
    public val diskNode: String,
    public val diskPath: String,
    public val gatewayArn: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.storagegateway.outputs.GetLocalDiskResult):
            GetLocalDiskResult = GetLocalDiskResult(
            diskId = javaType.diskId(),
            diskNode = javaType.diskNode(),
            diskPath = javaType.diskPath(),
            gatewayArn = javaType.gatewayArn(),
            id = javaType.id(),
        )
    }
}
