@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.swf.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.aws.swf.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides an SWF Domain resource.
 * ## Example Usage
 * To register a basic SWF domain:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.swf.Domain;
 * import com.pulumi.aws.swf.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Domain("foo", DomainArgs.builder()
 *             .description("SWF Domain")
 *             .workflowExecutionRetentionPeriodInDays(30)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SWF Domains using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:swf/domain:Domain foo test-domain
 * ```
 *
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.aws.swf.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The domain description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the domain. If omitted, this provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Length of time that SWF will continue to retain information about the workflow execution after the workflow execution is complete, must be between 0 and 90 days.
     */
    public val workflowExecutionRetentionPeriodInDays: Output<String>
        get() = javaResource.workflowExecutionRetentionPeriodInDays().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.swf.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.aws.swf.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
