@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.swf.kotlin

import com.pulumi.aws.swf.DomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an SWF Domain resource.
 * ## Example Usage
 * To register a basic SWF domain:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.swf.Domain;
 * import com.pulumi.aws.swf.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Domain("foo", DomainArgs.builder()
 *             .description("SWF Domain")
 *             .workflowExecutionRetentionPeriodInDays(30)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SWF Domains using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:swf/domain:Domain foo test-domain
 * ```
 * @property description The domain description.
 * @property name The name of the domain. If omitted, this provider will assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workflowExecutionRetentionPeriodInDays Length of time that SWF will continue to retain information about the workflow execution after the workflow execution is complete, must be between 0 and 90 days.
 */
public data class DomainArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workflowExecutionRetentionPeriodInDays: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.swf.DomainArgs> {
    override fun toJava(): com.pulumi.aws.swf.DomainArgs = com.pulumi.aws.swf.DomainArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .workflowExecutionRetentionPeriodInDays(
            workflowExecutionRetentionPeriodInDays?.applyValue({ args0 ->
                args0
            }),
        ).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workflowExecutionRetentionPeriodInDays: Output<String>? = null

    /**
     * @param value The domain description.
     */
    @JvmName("pkwjxuferllhtjtr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the domain. If omitted, this provider will assign a random, unique name.
     */
    @JvmName("cfhwixytblxlvsaa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("gxcthlpvtojnmflv")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("smedskvghykjwdbm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Length of time that SWF will continue to retain information about the workflow execution after the workflow execution is complete, must be between 0 and 90 days.
     */
    @JvmName("kgxmqsipvoyhnwwc")
    public suspend fun workflowExecutionRetentionPeriodInDays(`value`: Output<String>) {
        this.workflowExecutionRetentionPeriodInDays = value
    }

    /**
     * @param value The domain description.
     */
    @JvmName("kuhvsqwpnwiqvcdx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the domain. If omitted, this provider will assign a random, unique name.
     */
    @JvmName("axavjbbikhipehfx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("vohjikircqnithtq")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vyabiekuaxvvfnqq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bdabgutayuiarmbi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Length of time that SWF will continue to retain information about the workflow execution after the workflow execution is complete, must be between 0 and 90 days.
     */
    @JvmName("swqnfqcswnxkqltn")
    public suspend fun workflowExecutionRetentionPeriodInDays(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowExecutionRetentionPeriodInDays = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        description = description,
        name = name,
        namePrefix = namePrefix,
        tags = tags,
        workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays,
    )
}
