@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin

import com.pulumi.aws.synthetics.kotlin.outputs.CanaryArtifactConfig
import com.pulumi.aws.synthetics.kotlin.outputs.CanaryRunConfig
import com.pulumi.aws.synthetics.kotlin.outputs.CanarySchedule
import com.pulumi.aws.synthetics.kotlin.outputs.CanaryTimeline
import com.pulumi.aws.synthetics.kotlin.outputs.CanaryVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.synthetics.kotlin.outputs.CanaryArtifactConfig.Companion.toKotlin as canaryArtifactConfigToKotlin
import com.pulumi.aws.synthetics.kotlin.outputs.CanaryRunConfig.Companion.toKotlin as canaryRunConfigToKotlin
import com.pulumi.aws.synthetics.kotlin.outputs.CanarySchedule.Companion.toKotlin as canaryScheduleToKotlin
import com.pulumi.aws.synthetics.kotlin.outputs.CanaryTimeline.Companion.toKotlin as canaryTimelineToKotlin
import com.pulumi.aws.synthetics.kotlin.outputs.CanaryVpcConfig.Companion.toKotlin as canaryVpcConfigToKotlin

/**
 * Builder for [Canary].
 */
@PulumiTagMarker
public class CanaryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CanaryArgs = CanaryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CanaryArgsBuilder.() -> Unit) {
        val builder = CanaryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Canary {
        val builtJavaResource = com.pulumi.aws.synthetics.Canary(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Canary(builtJavaResource)
    }
}

/**
 * Provides a Synthetics Canary resource.
 * > **NOTE:** When you create a canary, AWS creates supporting implicit resources. See the Amazon CloudWatch Synthetics documentation on [DeleteCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html) for a full list. Neither AWS nor this provider deletes these implicit resources automatically when the canary is deleted. Before deleting a canary, ensure you have all the information about the canary that you need to delete the implicit resources using the AWS Console, or AWS CLI.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.synthetics.Canary;
 * import com.pulumi.aws.synthetics.CanaryArgs;
 * import com.pulumi.aws.synthetics.inputs.CanaryScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var some = new Canary("some", CanaryArgs.builder()
 *             .artifactS3Location("s3://some-bucket/")
 *             .executionRoleArn("some-role")
 *             .handler("exports.handler")
 *             .runtimeVersion("syn-1.0")
 *             .schedule(CanaryScheduleArgs.builder()
 *                 .expression("rate(0 minute)")
 *                 .build())
 *             .zipFile("test-fixtures/lambdatest.zip")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Synthetics Canaries using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:synthetics/canary:Canary some some-canary
 * ```
 *
 */
public class Canary internal constructor(
    override val javaResource: com.pulumi.aws.synthetics.Canary,
) : KotlinCustomResource(javaResource, CanaryMapper) {
    /**
     * Amazon Resource Name (ARN) of the Canary.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
     */
    public val artifactConfig: Output<CanaryArtifactConfig>?
        get() = javaResource.artifactConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> canaryArtifactConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
     */
    public val artifactS3Location: Output<String>
        get() = javaResource.artifactS3Location().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
     */
    public val deleteLambda: Output<Boolean>?
        get() = javaResource.deleteLambda().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the Lambda function that is used as your canary's engine.
     */
    public val engineArn: Output<String>
        get() = javaResource.engineArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
     */
    public val executionRoleArn: Output<String>
        get() = javaResource.executionRoleArn().applyValue({ args0 -> args0 })

    /**
     * Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    public val failureRetentionPeriod: Output<Int>?
        get() = javaResource.failureRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
     */
    public val handler: Output<String>
        get() = javaResource.handler().applyValue({ args0 -> args0 })

    /**
     * Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration block for individual canary runs. Detailed below.
     */
    public val runConfig: Output<CanaryRunConfig>
        get() = javaResource.runConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                canaryRunConfigToKotlin(args0)
            })
        })

    /**
     * Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
     */
    public val runtimeVersion: Output<String>
        get() = javaResource.runtimeVersion().applyValue({ args0 -> args0 })

    /**
     * Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
     */
    public val s3Bucket: Output<String>?
        get() = javaResource.s3Bucket().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * S3 key of your script. **Conflicts with `zip_file`.**
     */
    public val s3Key: Output<String>?
        get() = javaResource.s3Key().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * S3 version ID of your script. **Conflicts with `zip_file`.**
     */
    public val s3Version: Output<String>?
        get() = javaResource.s3Version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
     * The following arguments are optional:
     */
    public val schedule: Output<CanarySchedule>
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.let({ args0 ->
                canaryScheduleToKotlin(args0)
            })
        })

    /**
     * ARN of the Lambda layer where Synthetics stores the canary script code.
     */
    public val sourceLocationArn: Output<String>
        get() = javaResource.sourceLocationArn().applyValue({ args0 -> args0 })

    /**
     * Whether to run or stop the canary.
     */
    public val startCanary: Output<Boolean>?
        get() = javaResource.startCanary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Canary status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    public val successRetentionPeriod: Output<Int>?
        get() = javaResource.successRetentionPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Structure that contains information about when the canary was created, modified, and most recently run. see Timeline.
     */
    public val timelines: Output<List<CanaryTimeline>>
        get() = javaResource.timelines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    canaryTimelineToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block. Detailed below.
     */
    public val vpcConfig: Output<CanaryVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    canaryVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
     */
    public val zipFile: Output<String>?
        get() = javaResource.zipFile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object CanaryMapper : ResourceMapper<Canary> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.synthetics.Canary::class == javaResource::class

    override fun map(javaResource: Resource): Canary = Canary(
        javaResource as
            com.pulumi.aws.synthetics.Canary,
    )
}

/**
 * @see [Canary].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Canary].
 */
public suspend fun canary(name: String, block: suspend CanaryResourceBuilder.() -> Unit): Canary {
    val builder = CanaryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Canary].
 * @param name The _unique_ name of the resulting resource.
 */
public fun canary(name: String): Canary {
    val builder = CanaryResourceBuilder()
    builder.name(name)
    return builder.build()
}
