@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin

import com.pulumi.aws.synthetics.CanaryArgs.builder
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryArtifactConfigArgs
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryArtifactConfigArgsBuilder
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryRunConfigArgs
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryRunConfigArgsBuilder
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryScheduleArgs
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryScheduleArgsBuilder
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryVpcConfigArgs
import com.pulumi.aws.synthetics.kotlin.inputs.CanaryVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Synthetics Canary resource.
 * > **NOTE:** When you create a canary, AWS creates supporting implicit resources. See the Amazon CloudWatch Synthetics documentation on [DeleteCanary](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html) for a full list. Neither AWS nor this provider deletes these implicit resources automatically when the canary is deleted. Before deleting a canary, ensure you have all the information about the canary that you need to delete the implicit resources using the AWS Console, or AWS CLI.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.synthetics.Canary;
 * import com.pulumi.aws.synthetics.CanaryArgs;
 * import com.pulumi.aws.synthetics.inputs.CanaryScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var some = new Canary("some", CanaryArgs.builder()
 *             .artifactS3Location("s3://some-bucket/")
 *             .executionRoleArn("some-role")
 *             .handler("exports.handler")
 *             .runtimeVersion("syn-1.0")
 *             .schedule(CanaryScheduleArgs.builder()
 *                 .expression("rate(0 minute)")
 *                 .build())
 *             .zipFile("test-fixtures/lambdatest.zip")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Synthetics Canaries using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:synthetics/canary:Canary some some-canary
 * ```
 * @property artifactConfig configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
 * @property artifactS3Location Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
 * @property deleteLambda Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
 * @property executionRoleArn ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
 * @property failureRetentionPeriod Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
 * @property handler Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
 * @property name Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
 * @property runConfig Configuration block for individual canary runs. Detailed below.
 * @property runtimeVersion Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
 * @property s3Bucket Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
 * @property s3Key S3 key of your script. **Conflicts with `zip_file`.**
 * @property s3Version S3 version ID of your script. **Conflicts with `zip_file`.**
 * @property schedule Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
 * The following arguments are optional:
 * @property startCanary Whether to run or stop the canary.
 * @property successRetentionPeriod Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfig Configuration block. Detailed below.
 * @property zipFile ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
 */
public data class CanaryArgs(
    public val artifactConfig: Output<CanaryArtifactConfigArgs>? = null,
    public val artifactS3Location: Output<String>? = null,
    public val deleteLambda: Output<Boolean>? = null,
    public val executionRoleArn: Output<String>? = null,
    public val failureRetentionPeriod: Output<Int>? = null,
    public val handler: Output<String>? = null,
    public val name: Output<String>? = null,
    public val runConfig: Output<CanaryRunConfigArgs>? = null,
    public val runtimeVersion: Output<String>? = null,
    public val s3Bucket: Output<String>? = null,
    public val s3Key: Output<String>? = null,
    public val s3Version: Output<String>? = null,
    public val schedule: Output<CanaryScheduleArgs>? = null,
    public val startCanary: Output<Boolean>? = null,
    public val successRetentionPeriod: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<CanaryVpcConfigArgs>? = null,
    public val zipFile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.synthetics.CanaryArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.CanaryArgs =
        com.pulumi.aws.synthetics.CanaryArgs.builder()
            .artifactConfig(artifactConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .artifactS3Location(artifactS3Location?.applyValue({ args0 -> args0 }))
            .deleteLambda(deleteLambda?.applyValue({ args0 -> args0 }))
            .executionRoleArn(executionRoleArn?.applyValue({ args0 -> args0 }))
            .failureRetentionPeriod(failureRetentionPeriod?.applyValue({ args0 -> args0 }))
            .handler(handler?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .runConfig(runConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 }))
            .s3Bucket(s3Bucket?.applyValue({ args0 -> args0 }))
            .s3Key(s3Key?.applyValue({ args0 -> args0 }))
            .s3Version(s3Version?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startCanary(startCanary?.applyValue({ args0 -> args0 }))
            .successRetentionPeriod(successRetentionPeriod?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zipFile(zipFile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CanaryArgs].
 */
@PulumiTagMarker
public class CanaryArgsBuilder internal constructor() {
    private var artifactConfig: Output<CanaryArtifactConfigArgs>? = null

    private var artifactS3Location: Output<String>? = null

    private var deleteLambda: Output<Boolean>? = null

    private var executionRoleArn: Output<String>? = null

    private var failureRetentionPeriod: Output<Int>? = null

    private var handler: Output<String>? = null

    private var name: Output<String>? = null

    private var runConfig: Output<CanaryRunConfigArgs>? = null

    private var runtimeVersion: Output<String>? = null

    private var s3Bucket: Output<String>? = null

    private var s3Key: Output<String>? = null

    private var s3Version: Output<String>? = null

    private var schedule: Output<CanaryScheduleArgs>? = null

    private var startCanary: Output<Boolean>? = null

    private var successRetentionPeriod: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<CanaryVpcConfigArgs>? = null

    private var zipFile: Output<String>? = null

    /**
     * @param value configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
     */
    @JvmName("qoynkdccatsjjofb")
    public suspend fun artifactConfig(`value`: Output<CanaryArtifactConfigArgs>) {
        this.artifactConfig = value
    }

    /**
     * @param value Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
     */
    @JvmName("slhnuurgyyatdmhe")
    public suspend fun artifactS3Location(`value`: Output<String>) {
        this.artifactS3Location = value
    }

    /**
     * @param value Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
     */
    @JvmName("cmdseoeedfgrihmx")
    public suspend fun deleteLambda(`value`: Output<Boolean>) {
        this.deleteLambda = value
    }

    /**
     * @param value ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
     */
    @JvmName("quhujoiqcaarkxxs")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @JvmName("pydoioogifyrqojd")
    public suspend fun failureRetentionPeriod(`value`: Output<Int>) {
        this.failureRetentionPeriod = value
    }

    /**
     * @param value Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
     */
    @JvmName("imwgsbivaqjxxwfp")
    public suspend fun handler(`value`: Output<String>) {
        this.handler = value
    }

    /**
     * @param value Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
     */
    @JvmName("otfrxmcdefyjjdeb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for individual canary runs. Detailed below.
     */
    @JvmName("xeidfkikpmjapukj")
    public suspend fun runConfig(`value`: Output<CanaryRunConfigArgs>) {
        this.runConfig = value
    }

    /**
     * @param value Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
     */
    @JvmName("ssebqmbihnxwhydx")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
     */
    @JvmName("siqeiumxbnrmakxp")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value S3 key of your script. **Conflicts with `zip_file`.**
     */
    @JvmName("kogotkarfrpvjqhh")
    public suspend fun s3Key(`value`: Output<String>) {
        this.s3Key = value
    }

    /**
     * @param value S3 version ID of your script. **Conflicts with `zip_file`.**
     */
    @JvmName("ehcvcvijpbtxkouq")
    public suspend fun s3Version(`value`: Output<String>) {
        this.s3Version = value
    }

    /**
     * @param value Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("awpvocexocmnfkrs")
    public suspend fun schedule(`value`: Output<CanaryScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Whether to run or stop the canary.
     */
    @JvmName("poioixglkvoyfldl")
    public suspend fun startCanary(`value`: Output<Boolean>) {
        this.startCanary = value
    }

    /**
     * @param value Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @JvmName("gpqkeylfmxpfwama")
    public suspend fun successRetentionPeriod(`value`: Output<Int>) {
        this.successRetentionPeriod = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qqwiljandccmggna")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("nslgcxfcnmfpmgyq")
    public suspend fun vpcConfig(`value`: Output<CanaryVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
     */
    @JvmName("bscfjwfmguyfxpdg")
    public suspend fun zipFile(`value`: Output<String>) {
        this.zipFile = value
    }

    /**
     * @param value configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
     */
    @JvmName("xhxyyggjfosbgvvb")
    public suspend fun artifactConfig(`value`: CanaryArtifactConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactConfig = mapped
    }

    /**
     * @param argument configuration for canary artifacts, including the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See Artifact Config.
     */
    @JvmName("owemsorxetpgehji")
    public suspend fun artifactConfig(argument: suspend CanaryArtifactConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CanaryArtifactConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifactConfig = mapped
    }

    /**
     * @param value Location in Amazon S3 where Synthetics stores artifacts from the test runs of this canary.
     */
    @JvmName("bsxiaajpfekuqarv")
    public suspend fun artifactS3Location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactS3Location = mapped
    }

    /**
     * @param value Specifies whether to also delete the Lambda functions and layers used by this canary. The default is `false`.
     */
    @JvmName("fqkvkkbjrdlymqnp")
    public suspend fun deleteLambda(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteLambda = mapped
    }

    /**
     * @param value ARN of the IAM role to be used to run the canary. see [AWS Docs](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_CreateCanary.html#API_CreateCanary_RequestSyntax) for permissions needs for IAM Role.
     */
    @JvmName("etdrawiduitmrcqo")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value Number of days to retain data about failed runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @JvmName("sxmspxjrfrxrcyrs")
    public suspend fun failureRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureRetentionPeriod = mapped
    }

    /**
     * @param value Entry point to use for the source code when running the canary. This value must end with the string `.handler` .
     */
    @JvmName("wqfosobinqnhdmvj")
    public suspend fun handler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handler = mapped
    }

    /**
     * @param value Name for this canary. Has a maximum length of 21 characters. Valid characters are lowercase alphanumeric, hyphen, or underscore.
     */
    @JvmName("khvkagrbunhjiuiu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for individual canary runs. Detailed below.
     */
    @JvmName("wodawjslflquiotx")
    public suspend fun runConfig(`value`: CanaryRunConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runConfig = mapped
    }

    /**
     * @param argument Configuration block for individual canary runs. Detailed below.
     */
    @JvmName("csbnrgtscdgkybvi")
    public suspend fun runConfig(argument: suspend CanaryRunConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CanaryRunConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.runConfig = mapped
    }

    /**
     * @param value Runtime version to use for the canary. Versions change often so consult the [Amazon CloudWatch documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html) for the latest valid versions. Values include `syn-python-selenium-1.0`, `syn-nodejs-puppeteer-3.0`, `syn-nodejs-2.2`, `syn-nodejs-2.1`, `syn-nodejs-2.0`, and `syn-1.0`.
     */
    @JvmName("tcesgkvymlxkubur")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    /**
     * @param value Full bucket name which is used if your canary script is located in S3. The bucket must already exist. **Conflicts with `zip_file`.**
     */
    @JvmName("heivwnjryvjdfwvv")
    public suspend fun s3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value S3 key of your script. **Conflicts with `zip_file`.**
     */
    @JvmName("nxsokrclhfluywtj")
    public suspend fun s3Key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Key = mapped
    }

    /**
     * @param value S3 version ID of your script. **Conflicts with `zip_file`.**
     */
    @JvmName("vymqfgrfoaljggsn")
    public suspend fun s3Version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Version = mapped
    }

    /**
     * @param value Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("dfmhtgowruldcjyk")
    public suspend fun schedule(`value`: CanaryScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Configuration block providing how often the canary is to run and when these test runs are to stop. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("edcldbrlcwjmnwcp")
    public suspend fun schedule(argument: suspend CanaryScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = CanaryScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Whether to run or stop the canary.
     */
    @JvmName("fhyxnfsdsroaxsfl")
    public suspend fun startCanary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startCanary = mapped
    }

    /**
     * @param value Number of days to retain data about successful runs of this canary. If you omit this field, the default of 31 days is used. The valid range is 1 to 455 days.
     */
    @JvmName("mnghgbaxqbbegtyr")
    public suspend fun successRetentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successRetentionPeriod = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vpnlslurpgehdeys")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("evxdcpmwsxfslehp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("qxvkqgxlwariprvq")
    public suspend fun vpcConfig(`value`: CanaryVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("omsatdkvaoridrjf")
    public suspend fun vpcConfig(argument: suspend CanaryVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = CanaryVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    /**
     * @param value ZIP file that contains the script, if you input your canary script directly into the canary instead of referring to an S3 location. It can be up to 225KB. **Conflicts with `s3_bucket`, `s3_key`, and `s3_version`.**
     */
    @JvmName("llbkbkgtbffgexsl")
    public suspend fun zipFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipFile = mapped
    }

    internal fun build(): CanaryArgs = CanaryArgs(
        artifactConfig = artifactConfig,
        artifactS3Location = artifactS3Location,
        deleteLambda = deleteLambda,
        executionRoleArn = executionRoleArn,
        failureRetentionPeriod = failureRetentionPeriod,
        handler = handler,
        name = name,
        runConfig = runConfig,
        runtimeVersion = runtimeVersion,
        s3Bucket = s3Bucket,
        s3Key = s3Key,
        s3Version = s3Version,
        schedule = schedule,
        startCanary = startCanary,
        successRetentionPeriod = successRetentionPeriod,
        tags = tags,
        vpcConfig = vpcConfig,
        zipFile = zipFile,
    )
}
