@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupAssociation].
 */
@PulumiTagMarker
public class GroupAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupAssociationArgs = GroupAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupAssociationArgsBuilder.() -> Unit) {
        val builder = GroupAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GroupAssociation {
        val builtJavaResource = com.pulumi.aws.synthetics.GroupAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupAssociation(builtJavaResource)
    }
}

/**
 * Provides a Synthetics Group Association resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.synthetics.GroupAssociation;
 * import com.pulumi.aws.synthetics.GroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupAssociation("example", GroupAssociationArgs.builder()
 *             .groupName(aws_synthetics_group.example().name())
 *             .canaryArn(aws_synthetics_canary.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Synthetics Group Association using the `canary_arn,group_name`. For example:
 * ```sh
 *  $ pulumi import aws:synthetics/groupAssociation:GroupAssociation example arn:aws:synthetics:us-west-2:123456789012:canary:tf-acc-test-abcd1234,examplename
 * ```
 *
 */
public class GroupAssociation internal constructor(
    override val javaResource: com.pulumi.aws.synthetics.GroupAssociation,
) : KotlinCustomResource(javaResource, GroupAssociationMapper) {
    /**
     * ARN of the canary.
     */
    public val canaryArn: Output<String>
        get() = javaResource.canaryArn().applyValue({ args0 -> args0 })

    public val groupArn: Output<String>
        get() = javaResource.groupArn().applyValue({ args0 -> args0 })

    /**
     * ID of the Group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * Name of the group that the canary will be associated with.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })
}

public object GroupAssociationMapper : ResourceMapper<GroupAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.synthetics.GroupAssociation::class == javaResource::class

    override fun map(javaResource: Resource): GroupAssociation = GroupAssociation(
        javaResource as
            com.pulumi.aws.synthetics.GroupAssociation,
    )
}

/**
 * @see [GroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupAssociation].
 */
public suspend fun groupAssociation(
    name: String,
    block: suspend GroupAssociationResourceBuilder.() -> Unit,
): GroupAssociation {
    val builder = GroupAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupAssociation(name: String): GroupAssociation {
    val builder = GroupAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
