@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin

import com.pulumi.aws.synthetics.GroupAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Synthetics Group Association resource.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.synthetics.GroupAssociation;
 * import com.pulumi.aws.synthetics.GroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupAssociation("example", GroupAssociationArgs.builder()
 *             .groupName(aws_synthetics_group.example().name())
 *             .canaryArn(aws_synthetics_canary.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Synthetics Group Association using the `canary_arn,group_name`. For example:
 * ```sh
 *  $ pulumi import aws:synthetics/groupAssociation:GroupAssociation example arn:aws:synthetics:us-west-2:123456789012:canary:tf-acc-test-abcd1234,examplename
 * ```
 * @property canaryArn ARN of the canary.
 * @property groupName Name of the group that the canary will be associated with.
 */
public data class GroupAssociationArgs(
    public val canaryArn: Output<String>? = null,
    public val groupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.synthetics.GroupAssociationArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.GroupAssociationArgs =
        com.pulumi.aws.synthetics.GroupAssociationArgs.builder()
            .canaryArn(canaryArn?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupAssociationArgs].
 */
@PulumiTagMarker
public class GroupAssociationArgsBuilder internal constructor() {
    private var canaryArn: Output<String>? = null

    private var groupName: Output<String>? = null

    /**
     * @param value ARN of the canary.
     */
    @JvmName("isfyoenvlqsubgwb")
    public suspend fun canaryArn(`value`: Output<String>) {
        this.canaryArn = value
    }

    /**
     * @param value Name of the group that the canary will be associated with.
     */
    @JvmName("maquodsbjnnwcyhe")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value ARN of the canary.
     */
    @JvmName("gvpsftyurwgnrknq")
    public suspend fun canaryArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canaryArn = mapped
    }

    /**
     * @param value Name of the group that the canary will be associated with.
     */
    @JvmName("hwvidydmetqbsjeu")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    internal fun build(): GroupAssociationArgs = GroupAssociationArgs(
        canaryArn = canaryArn,
        groupName = groupName,
    )
}
