@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.inputs

import com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Encryption Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
 */
public data class CanaryArtifactConfigArgs(
    public val s3Encryption: Output<CanaryArtifactConfigS3EncryptionArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigArgs =
        com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigArgs.builder()
            .s3Encryption(s3Encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CanaryArtifactConfigArgs].
 */
@PulumiTagMarker
public class CanaryArtifactConfigArgsBuilder internal constructor() {
    private var s3Encryption: Output<CanaryArtifactConfigS3EncryptionArgs>? = null

    /**
     * @param value Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
     */
    @JvmName("brcjlxcdbtxgpprl")
    public suspend fun s3Encryption(`value`: Output<CanaryArtifactConfigS3EncryptionArgs>) {
        this.s3Encryption = value
    }

    /**
     * @param value Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
     */
    @JvmName("adrabfkfpqbklyko")
    public suspend fun s3Encryption(`value`: CanaryArtifactConfigS3EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Encryption = mapped
    }

    /**
     * @param argument Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
     */
    @JvmName("scuodnxcfnxuhtas")
    public suspend
    fun s3Encryption(argument: suspend CanaryArtifactConfigS3EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = CanaryArtifactConfigS3EncryptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Encryption = mapped
    }

    internal fun build(): CanaryArtifactConfigArgs = CanaryArtifactConfigArgs(
        s3Encryption = s3Encryption,
    )
}
