@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.inputs

import com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigS3EncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionMode The encryption method to use for artifacts created by this canary. Valid values are: `SSE_S3` and `SSE_KMS`.
 * @property kmsKeyArn The ARN of the customer-managed KMS key to use, if you specify `SSE_KMS` for `encryption_mode`.
 */
public data class CanaryArtifactConfigS3EncryptionArgs(
    public val encryptionMode: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigS3EncryptionArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigS3EncryptionArgs =
        com.pulumi.aws.synthetics.inputs.CanaryArtifactConfigS3EncryptionArgs.builder()
            .encryptionMode(encryptionMode?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CanaryArtifactConfigS3EncryptionArgs].
 */
@PulumiTagMarker
public class CanaryArtifactConfigS3EncryptionArgsBuilder internal constructor() {
    private var encryptionMode: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    /**
     * @param value The encryption method to use for artifacts created by this canary. Valid values are: `SSE_S3` and `SSE_KMS`.
     */
    @JvmName("momhhbqlvknmliyb")
    public suspend fun encryptionMode(`value`: Output<String>) {
        this.encryptionMode = value
    }

    /**
     * @param value The ARN of the customer-managed KMS key to use, if you specify `SSE_KMS` for `encryption_mode`.
     */
    @JvmName("jckqtlfgwuwgqljk")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The encryption method to use for artifacts created by this canary. Valid values are: `SSE_S3` and `SSE_KMS`.
     */
    @JvmName("lbsnbhgxnfcehata")
    public suspend fun encryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionMode = mapped
    }

    /**
     * @param value The ARN of the customer-managed KMS key to use, if you specify `SSE_KMS` for `encryption_mode`.
     */
    @JvmName("veampghfjdlsbmrc")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    internal fun build(): CanaryArtifactConfigS3EncryptionArgs = CanaryArtifactConfigS3EncryptionArgs(
        encryptionMode = encryptionMode,
        kmsKeyArn = kmsKeyArn,
    )
}
