@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.inputs

import com.pulumi.aws.synthetics.inputs.CanaryRunConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property activeTracing Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
 * @property environmentVariables Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
 * @property memoryInMb Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
 * @property timeoutInSeconds Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
 */
public data class CanaryRunConfigArgs(
    public val activeTracing: Output<Boolean>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val memoryInMb: Output<Int>? = null,
    public val timeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.synthetics.inputs.CanaryRunConfigArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.inputs.CanaryRunConfigArgs =
        com.pulumi.aws.synthetics.inputs.CanaryRunConfigArgs.builder()
            .activeTracing(activeTracing?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .memoryInMb(memoryInMb?.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CanaryRunConfigArgs].
 */
@PulumiTagMarker
public class CanaryRunConfigArgsBuilder internal constructor() {
    private var activeTracing: Output<Boolean>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var memoryInMb: Output<Int>? = null

    private var timeoutInSeconds: Output<Int>? = null

    /**
     * @param value Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
     */
    @JvmName("pwgrokcguvjuutua")
    public suspend fun activeTracing(`value`: Output<Boolean>) {
        this.activeTracing = value
    }

    /**
     * @param value Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
     */
    @JvmName("jrugujuwyvdtgyoj")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
     */
    @JvmName("lqbwudnmkkwlifmk")
    public suspend fun memoryInMb(`value`: Output<Int>) {
        this.memoryInMb = value
    }

    /**
     * @param value Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
     */
    @JvmName("cprakrejwcyrixby")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
     */
    @JvmName("owclcvlhheeprmlj")
    public suspend fun activeTracing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeTracing = mapped
    }

    /**
     * @param value Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
     */
    @JvmName("edqlcnirntgruwko")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
     */
    @JvmName("ccklxcmgdncrpcbl")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
     */
    @JvmName("rtjiqhinwrskgkol")
    public suspend fun memoryInMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryInMb = mapped
    }

    /**
     * @param value Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
     */
    @JvmName("thtubiiufvcjqjla")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    internal fun build(): CanaryRunConfigArgs = CanaryRunConfigArgs(
        activeTracing = activeTracing,
        environmentVariables = environmentVariables,
        memoryInMb = memoryInMb,
        timeoutInSeconds = timeoutInSeconds,
    )
}
