@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.inputs

import com.pulumi.aws.synthetics.inputs.CanaryScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property durationInSeconds Duration in seconds, for the canary to continue making regular runs according to the schedule in the Expression value.
 * @property expression Rate expression or cron expression that defines how often the canary is to run. For rate expression, the syntax is `rate(number unit)`. _unit_ can be `minute`, `minutes`, or `hour`. For cron expression, the syntax is `cron(expression)`. For more information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
 */
public data class CanaryScheduleArgs(
    public val durationInSeconds: Output<Int>? = null,
    public val expression: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.synthetics.inputs.CanaryScheduleArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.inputs.CanaryScheduleArgs =
        com.pulumi.aws.synthetics.inputs.CanaryScheduleArgs.builder()
            .durationInSeconds(durationInSeconds?.applyValue({ args0 -> args0 }))
            .expression(expression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CanaryScheduleArgs].
 */
@PulumiTagMarker
public class CanaryScheduleArgsBuilder internal constructor() {
    private var durationInSeconds: Output<Int>? = null

    private var expression: Output<String>? = null

    /**
     * @param value Duration in seconds, for the canary to continue making regular runs according to the schedule in the Expression value.
     */
    @JvmName("thnfeuqxuhpeekdf")
    public suspend fun durationInSeconds(`value`: Output<Int>) {
        this.durationInSeconds = value
    }

    /**
     * @param value Rate expression or cron expression that defines how often the canary is to run. For rate expression, the syntax is `rate(number unit)`. _unit_ can be `minute`, `minutes`, or `hour`. For cron expression, the syntax is `cron(expression)`. For more information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
     */
    @JvmName("fjoebpbbaljjjtdf")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value Duration in seconds, for the canary to continue making regular runs according to the schedule in the Expression value.
     */
    @JvmName("rfmarjituiebytbf")
    public suspend fun durationInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.durationInSeconds = mapped
    }

    /**
     * @param value Rate expression or cron expression that defines how often the canary is to run. For rate expression, the syntax is `rate(number unit)`. _unit_ can be `minute`, `minutes`, or `hour`. For cron expression, the syntax is `cron(expression)`. For more information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
     */
    @JvmName("pfrkkmigttgodtkw")
    public suspend fun expression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    internal fun build(): CanaryScheduleArgs = CanaryScheduleArgs(
        durationInSeconds = durationInSeconds,
        expression = expression ?: throw PulumiNullFieldException("expression"),
    )
}
