@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.inputs

import com.pulumi.aws.synthetics.inputs.CanaryVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds IDs of the security groups for this canary.
 * @property subnetIds IDs of the subnets where this canary is to run.
 * @property vpcId ID of the VPC where this canary is to run.
 */
public data class CanaryVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.synthetics.inputs.CanaryVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.inputs.CanaryVpcConfigArgs =
        com.pulumi.aws.synthetics.inputs.CanaryVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CanaryVpcConfigArgs].
 */
@PulumiTagMarker
public class CanaryVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value IDs of the security groups for this canary.
     */
    @JvmName("ugldvggixgpdexdm")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("idpafafsmfnupgwe")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values IDs of the security groups for this canary.
     */
    @JvmName("lrnjsiavvfbplleo")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value IDs of the subnets where this canary is to run.
     */
    @JvmName("jsrihacmutqjesif")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("hkwheeiqfrxvwvtc")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values IDs of the subnets where this canary is to run.
     */
    @JvmName("xegbvjxejrbgnaen")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value ID of the VPC where this canary is to run.
     */
    @JvmName("kbivhxkscpstmhkv")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value IDs of the security groups for this canary.
     */
    @JvmName("kefqymayxxtsnsdq")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values IDs of the security groups for this canary.
     */
    @JvmName("mnmwpuxuuoybymyp")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value IDs of the subnets where this canary is to run.
     */
    @JvmName("ywtamffjnebannrn")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values IDs of the subnets where this canary is to run.
     */
    @JvmName("mhletnfyxgcldtqb")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value ID of the VPC where this canary is to run.
     */
    @JvmName("hhjwyqnoijlkqyhr")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): CanaryVpcConfigArgs = CanaryVpcConfigArgs(
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        vpcId = vpcId,
    )
}
