@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property s3Encryption Configuration of the encryption-at-rest settings for artifacts that the canary uploads to Amazon S3. See S3 Encryption.
 */
public data class CanaryArtifactConfig(
    public val s3Encryption: CanaryArtifactConfigS3Encryption? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.synthetics.outputs.CanaryArtifactConfig):
            CanaryArtifactConfig = CanaryArtifactConfig(
            s3Encryption = javaType.s3Encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.synthetics.kotlin.outputs.CanaryArtifactConfigS3Encryption.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
