@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property activeTracing Whether this canary is to use active AWS X-Ray tracing when it runs. You can enable active tracing only for canaries that use version syn-nodejs-2.0 or later for their canary runtime.
 * @property environmentVariables Map of environment variables that are accessible from the canary during execution. Please see [AWS Docs](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime) for variables reserved for Lambda.
 * @property memoryInMb Maximum amount of memory available to the canary while it is running, in MB. The value you specify must be a multiple of 64.
 * @property timeoutInSeconds Number of seconds the canary is allowed to run before it must stop. If you omit this field, the frequency of the canary is used, up to a maximum of 840 (14 minutes).
 */
public data class CanaryRunConfig(
    public val activeTracing: Boolean? = null,
    public val environmentVariables: Map<String, String>? = null,
    public val memoryInMb: Int? = null,
    public val timeoutInSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.synthetics.outputs.CanaryRunConfig):
            CanaryRunConfig = CanaryRunConfig(
            activeTracing = javaType.activeTracing().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            memoryInMb = javaType.memoryInMb().map({ args0 -> args0 }).orElse(null),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
