@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds IDs of the security groups for this canary.
 * @property subnetIds IDs of the subnets where this canary is to run.
 * @property vpcId ID of the VPC where this canary is to run.
 */
public data class CanaryVpcConfig(
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.synthetics.outputs.CanaryVpcConfig):
            CanaryVpcConfig = CanaryVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
