@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Database].
 */
@PulumiTagMarker
public class DatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseArgs = DatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseArgsBuilder.() -> Unit) {
        val builder = DatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Database {
        val builtJavaResource = com.pulumi.aws.timestreamwrite.Database(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Database(builtJavaResource)
    }
}

/**
 * Provides a Timestream database resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Database;
 * import com.pulumi.aws.timestreamwrite.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Database("example", DatabaseArgs.builder()
 *             .databaseName("database-example")
 *             .build());
 *     }
 * }
 * ```
 * ### Full usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Database;
 * import com.pulumi.aws.timestreamwrite.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Database("example", DatabaseArgs.builder()
 *             .databaseName("database-example")
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .tags(Map.of("Name", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Timestream databases using the `database_name`. For example:
 * ```sh
 *  $ pulumi import aws:timestreamwrite/database:Database example example
 * ```
 *
 */
public class Database internal constructor(
    override val javaResource: com.pulumi.aws.timestreamwrite.Database,
) : KotlinCustomResource(javaResource, DatabaseMapper) {
    /**
     * The ARN that uniquely identifies this database.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the Timestream database. Minimum length of 3. Maximum length of 64.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * The ARN (not Alias ARN) of the KMS key to be used to encrypt the data stored in the database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. Refer to [AWS managed KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) for more info.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The total number of tables found within the Timestream database.
     */
    public val tableCount: Output<Int>
        get() = javaResource.tableCount().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DatabaseMapper : ResourceMapper<Database> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.timestreamwrite.Database::class == javaResource::class

    override fun map(javaResource: Resource): Database = Database(
        javaResource as
            com.pulumi.aws.timestreamwrite.Database,
    )
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Database].
 */
public suspend fun database(name: String, block: suspend DatabaseResourceBuilder.() -> Unit):
    Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 */
public fun database(name: String): Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
