@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin

import com.pulumi.aws.timestreamwrite.kotlin.outputs.TableMagneticStoreWriteProperties
import com.pulumi.aws.timestreamwrite.kotlin.outputs.TableRetentionProperties
import com.pulumi.aws.timestreamwrite.kotlin.outputs.TableSchema
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.timestreamwrite.kotlin.outputs.TableMagneticStoreWriteProperties.Companion.toKotlin as tableMagneticStoreWritePropertiesToKotlin
import com.pulumi.aws.timestreamwrite.kotlin.outputs.TableRetentionProperties.Companion.toKotlin as tableRetentionPropertiesToKotlin
import com.pulumi.aws.timestreamwrite.kotlin.outputs.TableSchema.Companion.toKotlin as tableSchemaToKotlin

/**
 * Builder for [Table].
 */
@PulumiTagMarker
public class TableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableArgs = TableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableArgsBuilder.() -> Unit) {
        val builder = TableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Table {
        val builtJavaResource = com.pulumi.aws.timestreamwrite.Table(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Table(builtJavaResource)
    }
}

/**
 * Provides a Timestream table resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(aws_timestreamwrite_database.example().database_name())
 *             .tableName("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Full usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableRetentionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(aws_timestreamwrite_database.example().database_name())
 *             .tableName("example")
 *             .retentionProperties(TableRetentionPropertiesArgs.builder()
 *                 .magneticStoreRetentionPeriodInDays(30)
 *                 .memoryStoreRetentionPeriodInHours(8)
 *                 .build())
 *             .tags(Map.of("Name", "example-timestream-table"))
 *             .build());
 *     }
 * }
 * ```
 * ### Customer-defined Partition Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableSchemaArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableSchemaCompositePartitionKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(aws_timestreamwrite_database.example().database_name())
 *             .tableName("example")
 *             .schema(TableSchemaArgs.builder()
 *                 .compositePartitionKey(TableSchemaCompositePartitionKeyArgs.builder()
 *                     .enforcementInRecord("REQUIRED")
 *                     .name("attr1")
 *                     .type("DIMENSION")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Timestream tables using the `table_name` and `database_name` separate by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:timestreamwrite/table:Table example ExampleTable:ExampleDatabase
 * ```
 *
 */
public class Table internal constructor(
    override val javaResource: com.pulumi.aws.timestreamwrite.Table,
) : KotlinCustomResource(javaResource, TableMapper) {
    /**
     * The ARN that uniquely identifies this table.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the Timestream database.
     */
    public val databaseName: Output<String>
        get() = javaResource.databaseName().applyValue({ args0 -> args0 })

    /**
     * Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
     */
    public val magneticStoreWriteProperties: Output<TableMagneticStoreWriteProperties>
        get() = javaResource.magneticStoreWriteProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                tableMagneticStoreWritePropertiesToKotlin(args0)
            })
        })

    /**
     * The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
     */
    public val retentionProperties: Output<TableRetentionProperties>
        get() = javaResource.retentionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                tableRetentionPropertiesToKotlin(args0)
            })
        })

    /**
     * The schema of the table. See Schema below for more details.
     */
    public val schema: Output<TableSchema>
        get() = javaResource.schema().applyValue({ args0 ->
            args0.let({ args0 ->
                tableSchemaToKotlin(args0)
            })
        })

    /**
     * The name of the Timestream table.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TableMapper : ResourceMapper<Table> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.timestreamwrite.Table::class == javaResource::class

    override fun map(javaResource: Resource): Table = Table(
        javaResource as
            com.pulumi.aws.timestreamwrite.Table,
    )
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Table].
 */
public suspend fun table(name: String, block: suspend TableResourceBuilder.() -> Unit): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Table].
 * @param name The _unique_ name of the resulting resource.
 */
public fun table(name: String): Table {
    val builder = TableResourceBuilder()
    builder.name(name)
    return builder.build()
}
