@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin

import com.pulumi.aws.timestreamwrite.TableArgs.builder
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableMagneticStoreWritePropertiesArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableMagneticStoreWritePropertiesArgsBuilder
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableRetentionPropertiesArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableRetentionPropertiesArgsBuilder
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableSchemaArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableSchemaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Timestream table resource.
 * ## Example Usage
 * ### Basic usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(aws_timestreamwrite_database.example().database_name())
 *             .tableName("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Full usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableRetentionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(aws_timestreamwrite_database.example().database_name())
 *             .tableName("example")
 *             .retentionProperties(TableRetentionPropertiesArgs.builder()
 *                 .magneticStoreRetentionPeriodInDays(30)
 *                 .memoryStoreRetentionPeriodInHours(8)
 *                 .build())
 *             .tags(Map.of("Name", "example-timestream-table"))
 *             .build());
 *     }
 * }
 * ```
 * ### Customer-defined Partition Key
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableSchemaArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableSchemaCompositePartitionKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(aws_timestreamwrite_database.example().database_name())
 *             .tableName("example")
 *             .schema(TableSchemaArgs.builder()
 *                 .compositePartitionKey(TableSchemaCompositePartitionKeyArgs.builder()
 *                     .enforcementInRecord("REQUIRED")
 *                     .name("attr1")
 *                     .type("DIMENSION")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Timestream tables using the `table_name` and `database_name` separate by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:timestreamwrite/table:Table example ExampleTable:ExampleDatabase
 * ```
 * @property databaseName The name of the Timestream database.
 * @property magneticStoreWriteProperties Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
 * @property retentionProperties The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
 * @property schema The schema of the table. See Schema below for more details.
 * @property tableName The name of the Timestream table.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TableArgs(
    public val databaseName: Output<String>? = null,
    public val magneticStoreWriteProperties: Output<TableMagneticStoreWritePropertiesArgs>? = null,
    public val retentionProperties: Output<TableRetentionPropertiesArgs>? = null,
    public val schema: Output<TableSchemaArgs>? = null,
    public val tableName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.TableArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.TableArgs =
        com.pulumi.aws.timestreamwrite.TableArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .magneticStoreWriteProperties(
                magneticStoreWriteProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .retentionProperties(
                retentionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TableArgs].
 */
@PulumiTagMarker
public class TableArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var magneticStoreWriteProperties: Output<TableMagneticStoreWritePropertiesArgs>? = null

    private var retentionProperties: Output<TableRetentionPropertiesArgs>? = null

    private var schema: Output<TableSchemaArgs>? = null

    private var tableName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Timestream database.
     */
    @JvmName("dyucuxjidgpdjmwo")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
     */
    @JvmName("monyuoclykokcfhe")
    public suspend
    fun magneticStoreWriteProperties(`value`: Output<TableMagneticStoreWritePropertiesArgs>) {
        this.magneticStoreWriteProperties = value
    }

    /**
     * @param value The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
     */
    @JvmName("qbppybrkacrhsure")
    public suspend fun retentionProperties(`value`: Output<TableRetentionPropertiesArgs>) {
        this.retentionProperties = value
    }

    /**
     * @param value The schema of the table. See Schema below for more details.
     */
    @JvmName("ddxaaftaqiwtaxyk")
    public suspend fun schema(`value`: Output<TableSchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value The name of the Timestream table.
     */
    @JvmName("snidanlbcbacfpln")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eegbixwwtnmlvhyu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Timestream database.
     */
    @JvmName("xprbgktkbixigiqq")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
     */
    @JvmName("leobxcahvdqxhwaw")
    public suspend fun magneticStoreWriteProperties(`value`: TableMagneticStoreWritePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.magneticStoreWriteProperties = mapped
    }

    /**
     * @param argument Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
     */
    @JvmName("ghpojfblidmjyebg")
    public suspend
    fun magneticStoreWriteProperties(argument: suspend TableMagneticStoreWritePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TableMagneticStoreWritePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.magneticStoreWriteProperties = mapped
    }

    /**
     * @param value The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
     */
    @JvmName("doylqticjaicphin")
    public suspend fun retentionProperties(`value`: TableRetentionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionProperties = mapped
    }

    /**
     * @param argument The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
     */
    @JvmName("kwexxufgdadpnlbk")
    public suspend
    fun retentionProperties(argument: suspend TableRetentionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TableRetentionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionProperties = mapped
    }

    /**
     * @param value The schema of the table. See Schema below for more details.
     */
    @JvmName("ypivwwipmqkaitlv")
    public suspend fun schema(`value`: TableSchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument The schema of the table. See Schema below for more details.
     */
    @JvmName("idjojicjochqmvsp")
    public suspend fun schema(argument: suspend TableSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = TableSchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value The name of the Timestream table.
     */
    @JvmName("hrixjjtsfanuhkhw")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tlghjrnwapvhouch")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("otujomunxqxweahm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TableArgs = TableArgs(
        databaseName = databaseName,
        magneticStoreWriteProperties = magneticStoreWriteProperties,
        retentionProperties = retentionProperties,
        schema = schema,
        tableName = tableName,
        tags = tags,
    )
}
