@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Configuration Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes. See S3 Configuration below for more details.
 */
public data class TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs(
    public val s3Configuration:
    Output<TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs> {
    override fun toJava():
        com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs =
        com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs.builder()
            .s3Configuration(
                s3Configuration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs].
 */
@PulumiTagMarker
public class TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgsBuilder internal
constructor() {
    private var s3Configuration:
        Output<TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs>? =
        null

    /**
     * @param value Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes. See S3 Configuration below for more details.
     */
    @JvmName("yvlkaxrsexonljih")
    public suspend
    fun s3Configuration(`value`: Output<TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes. See S3 Configuration below for more details.
     */
    @JvmName("mmnrfrnmtfipnbnu")
    public suspend
    fun s3Configuration(`value`: TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes. See S3 Configuration below for more details.
     */
    @JvmName("otpnmbaqjkcrtgiy")
    public suspend
    fun s3Configuration(argument: suspend TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    internal fun build(): TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs =
        TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs(
            s3Configuration = s3Configuration,
        )
}
