@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Bucket name of the customer S3 bucket.
 * @property encryptionOption Encryption option for the customer s3 location. Options are S3 server side encryption with an S3-managed key or KMS managed key. Valid values are `SSE_KMS` and `SSE_S3`.
 * @property kmsKeyId KMS key arn for the customer s3 location when encrypting with a KMS managed key.
 * @property objectKeyPrefix Object key prefix for the customer S3 location.
 */
public data class
TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs(
    public val bucketName: Output<String>? = null,
    public val encryptionOption: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val objectKeyPrefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs =
        com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .encryptionOption(encryptionOption?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .objectKeyPrefix(objectKeyPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs].
 */
@PulumiTagMarker
public class
TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgsBuilder
internal constructor() {
    private var bucketName: Output<String>? = null

    private var encryptionOption: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var objectKeyPrefix: Output<String>? = null

    /**
     * @param value Bucket name of the customer S3 bucket.
     */
    @JvmName("judqlqjrsmrrkjrt")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Encryption option for the customer s3 location. Options are S3 server side encryption with an S3-managed key or KMS managed key. Valid values are `SSE_KMS` and `SSE_S3`.
     */
    @JvmName("impcjjkcgqvvymmu")
    public suspend fun encryptionOption(`value`: Output<String>) {
        this.encryptionOption = value
    }

    /**
     * @param value KMS key arn for the customer s3 location when encrypting with a KMS managed key.
     */
    @JvmName("jelpdtlfduuqcbym")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Object key prefix for the customer S3 location.
     */
    @JvmName("jvsamoffpjwrapwi")
    public suspend fun objectKeyPrefix(`value`: Output<String>) {
        this.objectKeyPrefix = value
    }

    /**
     * @param value Bucket name of the customer S3 bucket.
     */
    @JvmName("kbmsqsxcgpwprexw")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Encryption option for the customer s3 location. Options are S3 server side encryption with an S3-managed key or KMS managed key. Valid values are `SSE_KMS` and `SSE_S3`.
     */
    @JvmName("gncfaddyiccrxdaj")
    public suspend fun encryptionOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionOption = mapped
    }

    /**
     * @param value KMS key arn for the customer s3 location when encrypting with a KMS managed key.
     */
    @JvmName("ntwqmojyvbkfjepa")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Object key prefix for the customer S3 location.
     */
    @JvmName("jrlgkjvjxoqqwbpn")
    public suspend fun objectKeyPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectKeyPrefix = mapped
    }

    internal fun build():
        TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs =
        TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3ConfigurationArgs(
            bucketName = bucketName,
            encryptionOption = encryptionOption,
            kmsKeyId = kmsKeyId,
            objectKeyPrefix = objectKeyPrefix,
        )
}
