@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enableMagneticStoreWrites A flag to enable magnetic store writes.
 * @property magneticStoreRejectedDataLocation The location to write error reports for records rejected asynchronously during magnetic store writes. See Magnetic Store Rejected Data Location below for more details.
 */
public data class TableMagneticStoreWriteProperties(
    public val enableMagneticStoreWrites: Boolean? = null,
    public val magneticStoreRejectedDataLocation:
    TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocation? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.TableMagneticStoreWriteProperties):
            TableMagneticStoreWriteProperties = TableMagneticStoreWriteProperties(
            enableMagneticStoreWrites = javaType.enableMagneticStoreWrites().map({ args0 ->
                args0
            }).orElse(null),
            magneticStoreRejectedDataLocation = javaType.magneticStoreRejectedDataLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.timestreamwrite.kotlin.outputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocation.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
