@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Bucket name of the customer S3 bucket.
 * @property encryptionOption Encryption option for the customer s3 location. Options are S3 server side encryption with an S3-managed key or KMS managed key. Valid values are `SSE_KMS` and `SSE_S3`.
 * @property kmsKeyId KMS key arn for the customer s3 location when encrypting with a KMS managed key.
 * @property objectKeyPrefix Object key prefix for the customer S3 location.
 */
public data class TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3Configuration(
    public val bucketName: String? = null,
    public val encryptionOption: String? = null,
    public val kmsKeyId: String? = null,
    public val objectKeyPrefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3Configuration):
            TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3Configuration =
            TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationS3Configuration(
                bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
                encryptionOption = javaType.encryptionOption().map({ args0 -> args0 }).orElse(null),
                kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
                objectKeyPrefix = javaType.objectKeyPrefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
