@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property magneticStoreRetentionPeriodInDays The duration for which data must be stored in the magnetic store. Minimum value of 1. Maximum value of 73000.
 * @property memoryStoreRetentionPeriodInHours The duration for which data must be stored in the memory store. Minimum value of 1. Maximum value of 8766.
 */
public data class TableRetentionProperties(
    public val magneticStoreRetentionPeriodInDays: Int,
    public val memoryStoreRetentionPeriodInHours: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.TableRetentionProperties):
            TableRetentionProperties = TableRetentionProperties(
            magneticStoreRetentionPeriodInDays = javaType.magneticStoreRetentionPeriodInDays(),
            memoryStoreRetentionPeriodInHours = javaType.memoryStoreRetentionPeriodInHours(),
        )
    }
}
