@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enforcementInRecord The level of enforcement for the specification of a dimension key in ingested records. Valid values: `REQUIRED`, `OPTIONAL`.
 * @property name The name of the attribute used for a dimension key.
 * @property type The type of the partition key. Valid values: `DIMENSION`, `MEASURE`.
 */
public data class TableSchemaCompositePartitionKey(
    public val enforcementInRecord: String? = null,
    public val name: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.TableSchemaCompositePartitionKey):
            TableSchemaCompositePartitionKey = TableSchemaCompositePartitionKey(
            enforcementInRecord = javaType.enforcementInRecord().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
