@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.aws.transcribe.kotlin.outputs.LanguageModelInputDataConfig
import com.pulumi.aws.transcribe.kotlin.outputs.LanguageModelInputDataConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LanguageModel].
 */
@PulumiTagMarker
public class LanguageModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LanguageModelArgs = LanguageModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LanguageModelArgsBuilder.() -> Unit) {
        val builder = LanguageModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LanguageModel {
        val builtJavaResource = com.pulumi.aws.transcribe.LanguageModel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LanguageModel(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Transcribe LanguageModel.
 * > This resource can take a significant amount of time to provision. See Language Model [FAQ](https://aws.amazon.com/transcribe/faqs/) for more details.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.transcribe.LanguageModel;
 * import com.pulumi.aws.transcribe.LanguageModelArgs;
 * import com.pulumi.aws.transcribe.inputs.LanguageModelInputDataConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transcribe.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testPolicy = new RolePolicy("testPolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "s3:GetObject",
 *                             "s3:ListBucket"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", jsonArray("*"))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var object = new BucketObjectv2("object", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("transcribe/test1.txt")
 *             .source(new FileAsset("test1.txt"))
 *             .build());
 *         var exampleLanguageModel = new LanguageModel("exampleLanguageModel", LanguageModelArgs.builder()
 *             .modelName("example")
 *             .baseModelName("NarrowBand")
 *             .inputDataConfig(LanguageModelInputDataConfigArgs.builder()
 *                 .dataAccessRoleArn(exampleRole.arn())
 *                 .s3Uri(exampleBucketV2.id().applyValue(id -> String.format("s3://%s/transcribe/", id)))
 *                 .build())
 *             .languageCode("en-US")
 *             .tags(Map.of("ENVIRONMENT", "development"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transcribe LanguageModel using the `model_name`. For example:
 * ```sh
 *  $ pulumi import aws:transcribe/languageModel:LanguageModel example example-name
 * ```
 *
 */
public class LanguageModel internal constructor(
    override val javaResource: com.pulumi.aws.transcribe.LanguageModel,
) : KotlinCustomResource(javaResource, LanguageModelMapper) {
    /**
     * ARN of the LanguageModel.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of reference base model.
     */
    public val baseModelName: Output<String>
        get() = javaResource.baseModelName().applyValue({ args0 -> args0 })

    /**
     * The input data config for the LanguageModel. See Input Data Config for more details.
     */
    public val inputDataConfig: Output<LanguageModelInputDataConfig>
        get() = javaResource.inputDataConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * The model name.
     */
    public val modelName: Output<String>
        get() = javaResource.modelName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the LanguageModel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LanguageModelMapper : ResourceMapper<LanguageModel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transcribe.LanguageModel::class == javaResource::class

    override fun map(javaResource: Resource): LanguageModel = LanguageModel(
        javaResource as
            com.pulumi.aws.transcribe.LanguageModel,
    )
}

/**
 * @see [LanguageModel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LanguageModel].
 */
public suspend fun languageModel(
    name: String,
    block: suspend LanguageModelResourceBuilder.() -> Unit,
): LanguageModel {
    val builder = LanguageModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LanguageModel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun languageModel(name: String): LanguageModel {
    val builder = LanguageModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
