@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.aws.transcribe.LanguageModelArgs.builder
import com.pulumi.aws.transcribe.kotlin.inputs.LanguageModelInputDataConfigArgs
import com.pulumi.aws.transcribe.kotlin.inputs.LanguageModelInputDataConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Transcribe LanguageModel.
 * > This resource can take a significant amount of time to provision. See Language Model [FAQ](https://aws.amazon.com/transcribe/faqs/) for more details.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.transcribe.LanguageModel;
 * import com.pulumi.aws.transcribe.LanguageModelArgs;
 * import com.pulumi.aws.transcribe.inputs.LanguageModelInputDataConfigArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transcribe.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testPolicy = new RolePolicy("testPolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray(
 *                             "s3:GetObject",
 *                             "s3:ListBucket"
 *                         )),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", jsonArray("*"))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var object = new BucketObjectv2("object", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("transcribe/test1.txt")
 *             .source(new FileAsset("test1.txt"))
 *             .build());
 *         var exampleLanguageModel = new LanguageModel("exampleLanguageModel", LanguageModelArgs.builder()
 *             .modelName("example")
 *             .baseModelName("NarrowBand")
 *             .inputDataConfig(LanguageModelInputDataConfigArgs.builder()
 *                 .dataAccessRoleArn(exampleRole.arn())
 *                 .s3Uri(exampleBucketV2.id().applyValue(id -> String.format("s3://%s/transcribe/", id)))
 *                 .build())
 *             .languageCode("en-US")
 *             .tags(Map.of("ENVIRONMENT", "development"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transcribe LanguageModel using the `model_name`. For example:
 * ```sh
 *  $ pulumi import aws:transcribe/languageModel:LanguageModel example example-name
 * ```
 * @property baseModelName Name of reference base model.
 * @property inputDataConfig The input data config for the LanguageModel. See Input Data Config for more details.
 * @property languageCode The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
 * @property modelName The model name.
 * @property tags A map of tags to assign to the LanguageModel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LanguageModelArgs(
    public val baseModelName: Output<String>? = null,
    public val inputDataConfig: Output<LanguageModelInputDataConfigArgs>? = null,
    public val languageCode: Output<String>? = null,
    public val modelName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transcribe.LanguageModelArgs> {
    override fun toJava(): com.pulumi.aws.transcribe.LanguageModelArgs =
        com.pulumi.aws.transcribe.LanguageModelArgs.builder()
            .baseModelName(baseModelName?.applyValue({ args0 -> args0 }))
            .inputDataConfig(inputDataConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LanguageModelArgs].
 */
@PulumiTagMarker
public class LanguageModelArgsBuilder internal constructor() {
    private var baseModelName: Output<String>? = null

    private var inputDataConfig: Output<LanguageModelInputDataConfigArgs>? = null

    private var languageCode: Output<String>? = null

    private var modelName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of reference base model.
     */
    @JvmName("wovgxymmpfhhyoro")
    public suspend fun baseModelName(`value`: Output<String>) {
        this.baseModelName = value
    }

    /**
     * @param value The input data config for the LanguageModel. See Input Data Config for more details.
     */
    @JvmName("tgjdvnqedympndbv")
    public suspend fun inputDataConfig(`value`: Output<LanguageModelInputDataConfigArgs>) {
        this.inputDataConfig = value
    }

    /**
     * @param value The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    @JvmName("klmtvxvqpxbqsycs")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value The model name.
     */
    @JvmName("tecrudncsmmnbhnq")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value A map of tags to assign to the LanguageModel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wvftawrbnlmfedft")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of reference base model.
     */
    @JvmName("erckpdqvxqrlcsfa")
    public suspend fun baseModelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseModelName = mapped
    }

    /**
     * @param value The input data config for the LanguageModel. See Input Data Config for more details.
     */
    @JvmName("xdhskmprbtmbuxos")
    public suspend fun inputDataConfig(`value`: LanguageModelInputDataConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDataConfig = mapped
    }

    /**
     * @param argument The input data config for the LanguageModel. See Input Data Config for more details.
     */
    @JvmName("mrgfxvslvbhluiva")
    public suspend
    fun inputDataConfig(argument: suspend LanguageModelInputDataConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LanguageModelInputDataConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputDataConfig = mapped
    }

    /**
     * @param value The language code you selected for your language model. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    @JvmName("dgbfqhlrxifkffxc")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value The model name.
     */
    @JvmName("scvjnkqyeuurgpbi")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value A map of tags to assign to the LanguageModel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("safjxsbvrukltvdc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the LanguageModel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("evftifivkyibjycp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LanguageModelArgs = LanguageModelArgs(
        baseModelName = baseModelName,
        inputDataConfig = inputDataConfig,
        languageCode = languageCode,
        modelName = modelName,
        tags = tags,
    )
}
