@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [MedicalVocabulary].
 */
@PulumiTagMarker
public class MedicalVocabularyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MedicalVocabularyArgs = MedicalVocabularyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MedicalVocabularyArgsBuilder.() -> Unit) {
        val builder = MedicalVocabularyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MedicalVocabulary {
        val builtJavaResource = com.pulumi.aws.transcribe.MedicalVocabulary(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MedicalVocabulary(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Transcribe MedicalVocabulary.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.transcribe.MedicalVocabulary;
 * import com.pulumi.aws.transcribe.MedicalVocabularyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var object = new BucketObjectv2("object", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("transcribe/test1.txt")
 *             .source(new FileAsset("test.txt"))
 *             .build());
 *         var exampleMedicalVocabulary = new MedicalVocabulary("exampleMedicalVocabulary", MedicalVocabularyArgs.builder()
 *             .vocabularyName("example")
 *             .languageCode("en-US")
 *             .vocabularyFileUri(Output.tuple(exampleBucketV2.id(), object.key()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", id,key);
 *             }))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value3")
 *             ))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(object)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transcribe MedicalVocabulary using the `vocabulary_name`. For example:
 * ```sh
 *  $ pulumi import aws:transcribe/medicalVocabulary:MedicalVocabulary example example-name
 * ```
 *
 */
public class MedicalVocabulary internal constructor(
    override val javaResource: com.pulumi.aws.transcribe.MedicalVocabulary,
) : KotlinCustomResource(javaResource, MedicalVocabularyMapper) {
    /**
     * ARN of the MedicalVocabulary.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Generated download URI.
     */
    public val downloadUri: Output<String>
        get() = javaResource.downloadUri().applyValue({ args0 -> args0 })

    /**
     * The language code you selected for your medical vocabulary. US English (en-US) is the only language supported with Amazon Transcribe Medical.
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary.
     */
    public val vocabularyFileUri: Output<String>
        get() = javaResource.vocabularyFileUri().applyValue({ args0 -> args0 })

    /**
     * The name of the Medical Vocabulary.
     * The following arguments are optional:
     */
    public val vocabularyName: Output<String>
        get() = javaResource.vocabularyName().applyValue({ args0 -> args0 })
}

public object MedicalVocabularyMapper : ResourceMapper<MedicalVocabulary> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transcribe.MedicalVocabulary::class == javaResource::class

    override fun map(javaResource: Resource): MedicalVocabulary = MedicalVocabulary(
        javaResource as
            com.pulumi.aws.transcribe.MedicalVocabulary,
    )
}

/**
 * @see [MedicalVocabulary].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MedicalVocabulary].
 */
public suspend fun medicalVocabulary(
    name: String,
    block: suspend MedicalVocabularyResourceBuilder.() -> Unit,
): MedicalVocabulary {
    val builder = MedicalVocabularyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MedicalVocabulary].
 * @param name The _unique_ name of the resulting resource.
 */
public fun medicalVocabulary(name: String): MedicalVocabulary {
    val builder = MedicalVocabularyResourceBuilder()
    builder.name(name)
    return builder.build()
}
