@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.aws.transcribe.MedicalVocabularyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Transcribe MedicalVocabulary.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.transcribe.MedicalVocabulary;
 * import com.pulumi.aws.transcribe.MedicalVocabularyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .forceDestroy(true)
 *             .build());
 *         var object = new BucketObjectv2("object", BucketObjectv2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .key("transcribe/test1.txt")
 *             .source(new FileAsset("test.txt"))
 *             .build());
 *         var exampleMedicalVocabulary = new MedicalVocabulary("exampleMedicalVocabulary", MedicalVocabularyArgs.builder()
 *             .vocabularyName("example")
 *             .languageCode("en-US")
 *             .vocabularyFileUri(Output.tuple(exampleBucketV2.id(), object.key()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", id,key);
 *             }))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value3")
 *             ))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(object)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transcribe MedicalVocabulary using the `vocabulary_name`. For example:
 * ```sh
 *  $ pulumi import aws:transcribe/medicalVocabulary:MedicalVocabulary example example-name
 * ```
 * @property languageCode The language code you selected for your medical vocabulary. US English (en-US) is the only language supported with Amazon Transcribe Medical.
 * @property tags A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vocabularyFileUri The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary.
 * @property vocabularyName The name of the Medical Vocabulary.
 * The following arguments are optional:
 */
public data class MedicalVocabularyArgs(
    public val languageCode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vocabularyFileUri: Output<String>? = null,
    public val vocabularyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transcribe.MedicalVocabularyArgs> {
    override fun toJava(): com.pulumi.aws.transcribe.MedicalVocabularyArgs =
        com.pulumi.aws.transcribe.MedicalVocabularyArgs.builder()
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vocabularyFileUri(vocabularyFileUri?.applyValue({ args0 -> args0 }))
            .vocabularyName(vocabularyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MedicalVocabularyArgs].
 */
@PulumiTagMarker
public class MedicalVocabularyArgsBuilder internal constructor() {
    private var languageCode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vocabularyFileUri: Output<String>? = null

    private var vocabularyName: Output<String>? = null

    /**
     * @param value The language code you selected for your medical vocabulary. US English (en-US) is the only language supported with Amazon Transcribe Medical.
     */
    @JvmName("gywwxppmqgvjsgei")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nqdihkhldpgrprcr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary.
     */
    @JvmName("myelgyvhgpeagcsc")
    public suspend fun vocabularyFileUri(`value`: Output<String>) {
        this.vocabularyFileUri = value
    }

    /**
     * @param value The name of the Medical Vocabulary.
     * The following arguments are optional:
     */
    @JvmName("hmxwmjmdovwxktli")
    public suspend fun vocabularyName(`value`: Output<String>) {
        this.vocabularyName = value
    }

    /**
     * @param value The language code you selected for your medical vocabulary. US English (en-US) is the only language supported with Amazon Transcribe Medical.
     */
    @JvmName("hqfjrnvbsbqtueuh")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rqeknipqwhstvvjf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("snehueegsjiohxee")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary.
     */
    @JvmName("civixvuutpmwfcgd")
    public suspend fun vocabularyFileUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFileUri = mapped
    }

    /**
     * @param value The name of the Medical Vocabulary.
     * The following arguments are optional:
     */
    @JvmName("mfbtevunangcyhph")
    public suspend fun vocabularyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyName = mapped
    }

    internal fun build(): MedicalVocabularyArgs = MedicalVocabularyArgs(
        languageCode = languageCode,
        tags = tags,
        vocabularyFileUri = vocabularyFileUri,
        vocabularyName = vocabularyName,
    )
}
