@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VocabularyFilter].
 */
@PulumiTagMarker
public class VocabularyFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VocabularyFilterArgs = VocabularyFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VocabularyFilterArgsBuilder.() -> Unit) {
        val builder = VocabularyFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VocabularyFilter {
        val builtJavaResource = com.pulumi.aws.transcribe.VocabularyFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VocabularyFilter(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Transcribe VocabularyFilter.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transcribe.VocabularyFilter;
 * import com.pulumi.aws.transcribe.VocabularyFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VocabularyFilter("example", VocabularyFilterArgs.builder()
 *             .languageCode("en-US")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value3")
 *             ))
 *             .vocabularyFilterName("example")
 *             .words(
 *                 "cars",
 *                 "bucket")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transcribe VocabularyFilter using the `vocabulary_filter_name`. For example:
 * ```sh
 *  $ pulumi import aws:transcribe/vocabularyFilter:VocabularyFilter example example-name
 * ```
 *
 */
public class VocabularyFilter internal constructor(
    override val javaResource: com.pulumi.aws.transcribe.VocabularyFilter,
) : KotlinCustomResource(javaResource, VocabularyFilterMapper) {
    /**
     * ARN of the VocabularyFilter.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Generated download URI.
     */
    public val downloadUri: Output<String>
        get() = javaResource.downloadUri().applyValue({ args0 -> args0 })

    /**
     * The language code you selected for your vocabulary filter. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon S3 location (URI) of the text file that contains your custom VocabularyFilter. Conflicts with `words` argument.
     */
    public val vocabularyFilterFileUri: Output<String>?
        get() = javaResource.vocabularyFilterFileUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the VocabularyFilter.
     * The following arguments are optional:
     */
    public val vocabularyFilterName: Output<String>
        get() = javaResource.vocabularyFilterName().applyValue({ args0 -> args0 })

    /**
     * A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    public val words: Output<List<String>>?
        get() = javaResource.words().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object VocabularyFilterMapper : ResourceMapper<VocabularyFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transcribe.VocabularyFilter::class == javaResource::class

    override fun map(javaResource: Resource): VocabularyFilter = VocabularyFilter(
        javaResource as
            com.pulumi.aws.transcribe.VocabularyFilter,
    )
}

/**
 * @see [VocabularyFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VocabularyFilter].
 */
public suspend fun vocabularyFilter(
    name: String,
    block: suspend VocabularyFilterResourceBuilder.() -> Unit,
): VocabularyFilter {
    val builder = VocabularyFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VocabularyFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vocabularyFilter(name: String): VocabularyFilter {
    val builder = VocabularyFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
