@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.aws.transcribe.VocabularyFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Transcribe VocabularyFilter.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transcribe.VocabularyFilter;
 * import com.pulumi.aws.transcribe.VocabularyFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VocabularyFilter("example", VocabularyFilterArgs.builder()
 *             .languageCode("en-US")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value3")
 *             ))
 *             .vocabularyFilterName("example")
 *             .words(
 *                 "cars",
 *                 "bucket")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transcribe VocabularyFilter using the `vocabulary_filter_name`. For example:
 * ```sh
 *  $ pulumi import aws:transcribe/vocabularyFilter:VocabularyFilter example example-name
 * ```
 * @property languageCode The language code you selected for your vocabulary filter. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
 * @property tags A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vocabularyFilterFileUri The Amazon S3 location (URI) of the text file that contains your custom VocabularyFilter. Conflicts with `words` argument.
 * @property vocabularyFilterName The name of the VocabularyFilter.
 * The following arguments are optional:
 * @property words A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
 */
public data class VocabularyFilterArgs(
    public val languageCode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vocabularyFilterFileUri: Output<String>? = null,
    public val vocabularyFilterName: Output<String>? = null,
    public val words: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transcribe.VocabularyFilterArgs> {
    override fun toJava(): com.pulumi.aws.transcribe.VocabularyFilterArgs =
        com.pulumi.aws.transcribe.VocabularyFilterArgs.builder()
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vocabularyFilterFileUri(vocabularyFilterFileUri?.applyValue({ args0 -> args0 }))
            .vocabularyFilterName(vocabularyFilterName?.applyValue({ args0 -> args0 }))
            .words(words?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VocabularyFilterArgs].
 */
@PulumiTagMarker
public class VocabularyFilterArgsBuilder internal constructor() {
    private var languageCode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vocabularyFilterFileUri: Output<String>? = null

    private var vocabularyFilterName: Output<String>? = null

    private var words: Output<List<String>>? = null

    /**
     * @param value The language code you selected for your vocabulary filter. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    @JvmName("mtowonbgldaeytpw")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jivtrutsyqthqelt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom VocabularyFilter. Conflicts with `words` argument.
     */
    @JvmName("bfqcmhnpcirokpay")
    public suspend fun vocabularyFilterFileUri(`value`: Output<String>) {
        this.vocabularyFilterFileUri = value
    }

    /**
     * @param value The name of the VocabularyFilter.
     * The following arguments are optional:
     */
    @JvmName("erdrhoraipqiyetb")
    public suspend fun vocabularyFilterName(`value`: Output<String>) {
        this.vocabularyFilterName = value
    }

    /**
     * @param value A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("heapounkvtlduwrk")
    public suspend fun words(`value`: Output<List<String>>) {
        this.words = value
    }

    @JvmName("davxjuvhtwshvvyk")
    public suspend fun words(vararg values: Output<String>) {
        this.words = Output.all(values.asList())
    }

    /**
     * @param values A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("dtcefuenmokkeuse")
    public suspend fun words(values: List<Output<String>>) {
        this.words = Output.all(values)
    }

    /**
     * @param value The language code you selected for your vocabulary filter. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    @JvmName("ayiuumtuajymhnim")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ewsxtkywtauauisd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("voaydajrbvhyelkh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom VocabularyFilter. Conflicts with `words` argument.
     */
    @JvmName("yexnnujkcmjekpjs")
    public suspend fun vocabularyFilterFileUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterFileUri = mapped
    }

    /**
     * @param value The name of the VocabularyFilter.
     * The following arguments are optional:
     */
    @JvmName("pghgbtvafubkxjgl")
    public suspend fun vocabularyFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterName = mapped
    }

    /**
     * @param value A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("deuwlgxnjydrleki")
    public suspend fun words(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.words = mapped
    }

    /**
     * @param values A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("fasjcherteibucod")
    public suspend fun words(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.words = mapped
    }

    internal fun build(): VocabularyFilterArgs = VocabularyFilterArgs(
        languageCode = languageCode,
        tags = tags,
        vocabularyFilterFileUri = vocabularyFilterFileUri,
        vocabularyFilterName = vocabularyFilterName,
        words = words,
    )
}
