@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin.inputs

import com.pulumi.aws.transcribe.inputs.LanguageModelInputDataConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataAccessRoleArn IAM role with access to S3 bucket.
 * @property s3Uri S3 URI where training data is located.
 * @property tuningDataS3Uri S3 URI where tuning data is located.
 * The following arguments are optional:
 */
public data class LanguageModelInputDataConfigArgs(
    public val dataAccessRoleArn: Output<String>,
    public val s3Uri: Output<String>,
    public val tuningDataS3Uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transcribe.inputs.LanguageModelInputDataConfigArgs> {
    override fun toJava(): com.pulumi.aws.transcribe.inputs.LanguageModelInputDataConfigArgs =
        com.pulumi.aws.transcribe.inputs.LanguageModelInputDataConfigArgs.builder()
            .dataAccessRoleArn(dataAccessRoleArn.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 }))
            .tuningDataS3Uri(tuningDataS3Uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LanguageModelInputDataConfigArgs].
 */
@PulumiTagMarker
public class LanguageModelInputDataConfigArgsBuilder internal constructor() {
    private var dataAccessRoleArn: Output<String>? = null

    private var s3Uri: Output<String>? = null

    private var tuningDataS3Uri: Output<String>? = null

    /**
     * @param value IAM role with access to S3 bucket.
     */
    @JvmName("gomvjslmarcbtcsi")
    public suspend fun dataAccessRoleArn(`value`: Output<String>) {
        this.dataAccessRoleArn = value
    }

    /**
     * @param value S3 URI where training data is located.
     */
    @JvmName("hmydtgfdpctitjiw")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value S3 URI where tuning data is located.
     * The following arguments are optional:
     */
    @JvmName("sflyjmddrtkrjbuv")
    public suspend fun tuningDataS3Uri(`value`: Output<String>) {
        this.tuningDataS3Uri = value
    }

    /**
     * @param value IAM role with access to S3 bucket.
     */
    @JvmName("eooxqvrkpkhpsyho")
    public suspend fun dataAccessRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataAccessRoleArn = mapped
    }

    /**
     * @param value S3 URI where training data is located.
     */
    @JvmName("dsjaibptqpcusmor")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    /**
     * @param value S3 URI where tuning data is located.
     * The following arguments are optional:
     */
    @JvmName("nhuwuiwkuonjamvi")
    public suspend fun tuningDataS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tuningDataS3Uri = mapped
    }

    internal fun build(): LanguageModelInputDataConfigArgs = LanguageModelInputDataConfigArgs(
        dataAccessRoleArn = dataAccessRoleArn ?: throw PulumiNullFieldException("dataAccessRoleArn"),
        s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
        tuningDataS3Uri = tuningDataS3Uri,
    )
}
