@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataAccessRoleArn IAM role with access to S3 bucket.
 * @property s3Uri S3 URI where training data is located.
 * @property tuningDataS3Uri S3 URI where tuning data is located.
 * The following arguments are optional:
 */
public data class LanguageModelInputDataConfig(
    public val dataAccessRoleArn: String,
    public val s3Uri: String,
    public val tuningDataS3Uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transcribe.outputs.LanguageModelInputDataConfig):
            LanguageModelInputDataConfig = LanguageModelInputDataConfig(
            dataAccessRoleArn = javaType.dataAccessRoleArn(),
            s3Uri = javaType.s3Uri(),
            tuningDataS3Uri = javaType.tuningDataS3Uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
