@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Agreement].
 */
@PulumiTagMarker
public class AgreementResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgreementArgs = AgreementArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgreementArgsBuilder.() -> Unit) {
        val builder = AgreementArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Agreement {
        val builtJavaResource = com.pulumi.aws.transfer.Agreement(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Agreement(builtJavaResource)
    }
}

/**
 * Provides a AWS Transfer AS2 Agreement resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Agreement;
 * import com.pulumi.aws.transfer.AgreementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Agreement("example", AgreementArgs.builder()
 *             .accessRole(aws_iam_role.test().arn())
 *             .baseDirectory("/DOC-EXAMPLE-BUCKET/home/mydirectory")
 *             .description("example")
 *             .localProfileId(aws_transfer_profile.local().profile_id())
 *             .partnerProfileId(aws_transfer_profile.partner().profile_id())
 *             .serverId(aws_transfer_server.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Agreement using the `server_id/agreement_id`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/agreement:Agreement example s-4221a88afd5f4362a/a-4221a88afd5f4362a
 * ```
 *
 */
public class Agreement internal constructor(
    override val javaResource: com.pulumi.aws.transfer.Agreement,
) : KotlinCustomResource(javaResource, AgreementMapper) {
    /**
     * The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     */
    public val accessRole: Output<String>
        get() = javaResource.accessRole().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the AS2 agreement.
     */
    public val agreementId: Output<String>
        get() = javaResource.agreementId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the agreement.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The landing directory for the files transferred by using the AS2 protocol.
     */
    public val baseDirectory: Output<String>
        get() = javaResource.baseDirectory().applyValue({ args0 -> args0 })

    /**
     * The Optional description of the transdfer.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique identifier for the AS2 local profile.
     */
    public val localProfileId: Output<String>
        get() = javaResource.localProfileId().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the AS2 partner profile.
     */
    public val partnerProfileId: Output<String>
        get() = javaResource.partnerProfileId().applyValue({ args0 -> args0 })

    /**
     * The unique server identifier for the server instance. This is the specific server the agreement uses.
     */
    public val serverId: Output<String>
        get() = javaResource.serverId().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AgreementMapper : ResourceMapper<Agreement> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transfer.Agreement::class == javaResource::class

    override fun map(javaResource: Resource): Agreement = Agreement(
        javaResource as
            com.pulumi.aws.transfer.Agreement,
    )
}

/**
 * @see [Agreement].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Agreement].
 */
public suspend fun agreement(name: String, block: suspend AgreementResourceBuilder.() -> Unit):
    Agreement {
    val builder = AgreementResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Agreement].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agreement(name: String): Agreement {
    val builder = AgreementResourceBuilder()
    builder.name(name)
    return builder.build()
}
