@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer AS2 Certificate resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Certificate;
 * import com.pulumi.aws.transfer.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Certificate("example", CertificateArgs.builder()
 *             .certificate(Files.readString(Paths.get(String.format("%s/example.com/example.crt", path.module()))))
 *             .certificateChain(Files.readString(Paths.get(String.format("%s/example.com/ca.crt", path.module()))))
 *             .privateKey(Files.readString(Paths.get(String.format("%s/example.com/example.key", path.module()))))
 *             .description("example")
 *             .usage("SIGNING")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Certificate using the `certificate_id`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/certificate:Certificate example c-4221a88afd5f4362a
 * ```
 * @property certificate The valid certificate file required for the transfer.
 * @property certificateChain The optional list of certificate that make up the chain for the certificate that is being imported.
 * @property description A short description that helps identify the certificate.
 * @property privateKey The private key associated with the certificate being imported.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property usage Specifies if a certificate is being used for signing or encryption. The valid values are SIGNING and ENCRYPTION.
 */
public data class CertificateArgs(
    public val certificate: Output<String>? = null,
    public val certificateChain: Output<String>? = null,
    public val description: Output<String>? = null,
    public val privateKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val usage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.CertificateArgs> {
    override fun toJava(): com.pulumi.aws.transfer.CertificateArgs =
        com.pulumi.aws.transfer.CertificateArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .certificateChain(certificateChain?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .usage(usage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var certificateChain: Output<String>? = null

    private var description: Output<String>? = null

    private var privateKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var usage: Output<String>? = null

    /**
     * @param value The valid certificate file required for the transfer.
     */
    @JvmName("iyeltqtpuocknven")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The optional list of certificate that make up the chain for the certificate that is being imported.
     */
    @JvmName("pgwafdhlwfrutuhp")
    public suspend fun certificateChain(`value`: Output<String>) {
        this.certificateChain = value
    }

    /**
     * @param value A short description that helps identify the certificate.
     */
    @JvmName("vtmnmmhlmbyagmgp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private key associated with the certificate being imported.
     */
    @JvmName("pyduxqewadcfkkrw")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ycmovjvbvdhnjwem")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies if a certificate is being used for signing or encryption. The valid values are SIGNING and ENCRYPTION.
     */
    @JvmName("cmcwqcwhxgctuyox")
    public suspend fun usage(`value`: Output<String>) {
        this.usage = value
    }

    /**
     * @param value The valid certificate file required for the transfer.
     */
    @JvmName("pivexmjftmelvlqv")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The optional list of certificate that make up the chain for the certificate that is being imported.
     */
    @JvmName("bsuvmgbictgyyxsn")
    public suspend fun certificateChain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateChain = mapped
    }

    /**
     * @param value A short description that helps identify the certificate.
     */
    @JvmName("etwreujxjspnrfhj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private key associated with the certificate being imported.
     */
    @JvmName("rmsfaxbgqtkttvet")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cwrnlcdmepulmlpo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tfuduundbkplisqn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies if a certificate is being used for signing or encryption. The valid values are SIGNING and ENCRYPTION.
     */
    @JvmName("qfyywoscrahdpqnt")
    public suspend fun usage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usage = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificate = certificate,
        certificateChain = certificateChain,
        description = description,
        privateKey = privateKey,
        tags = tags,
        usage = usage,
    )
}
